/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.hazelcast;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryEvent;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.cache.hazelcast.HazelcastCacheManager;
import com.atlassian.cache.hazelcast.ManagedHybridCacheSupport;
import com.atlassian.cache.impl.CacheEntryListenerSupport;
import com.atlassian.cache.impl.ValueCacheEntryListenerSupport;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.MembershipAdapter;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.Message;
import com.hazelcast.topic.MessageListener;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;

public class HazelcastAsyncHybridCache<K, V>
extends ManagedHybridCacheSupport
implements Cache<K, V> {
    private final AsyncInvalidationListener<K> listener;
    private final Cache<K, V> localCache;
    private final CacheEntryListenerSupport<K, V> listenerSupport = new ValueCacheEntryListenerSupport<K, V>(){

        protected void initValue(CacheEntryListenerSupport<K, V> actualListenerSupport) {
            HazelcastAsyncHybridCache.this.localCache.addListener(new DelegatingCacheEntryListener(actualListenerSupport), true);
        }

        protected void initValueless(CacheEntryListenerSupport<K, V> actualListenerSupport) {
            HazelcastAsyncHybridCache.this.localCache.addListener(new DelegatingCacheEntryListener(actualListenerSupport), false);
        }
    };

    public HazelcastAsyncHybridCache(String name, CacheFactory localCacheFactory, ITopic<Invalidate> invalidationTopic, CacheLoader<K, V> cacheLoader, HazelcastCacheManager cacheManager, CacheSettings settings) {
        super(name, cacheManager);
        this.localCache = localCacheFactory.getCache(name, cacheLoader, settings);
        this.listener = new AsyncInvalidationListener<K>(cacheManager.getHazelcastInstance().getCluster(), this.localCache, invalidationTopic);
    }

    public void clear() {
        this.removeAll();
    }

    public boolean containsKey(@Nonnull K key) {
        return this.localCache.containsKey(key);
    }

    public V get(@Nonnull K key) {
        return (V)this.localCache.get(key);
    }

    @Nonnull
    public V get(@Nonnull K key, @Nonnull Supplier<? extends V> valueSupplier) {
        return (V)this.localCache.get(key, valueSupplier);
    }

    @Nonnull
    public Map<K, V> getBulk(@Nonnull Set<K> keys, @Nonnull Function<Set<K>, Map<K, V>> valuesSupplier) {
        return this.localCache.getBulk(keys, valuesSupplier);
    }

    @Nonnull
    public Collection<K> getKeys() {
        return this.localCache.getKeys();
    }

    @Override
    @Nonnull
    public String getName() {
        return this.localCache.getName();
    }

    public boolean isFlushable() {
        return true;
    }

    public boolean isReplicateAsynchronously() {
        return true;
    }

    public void put(@Nonnull K key, @Nonnull V value) {
        this.invalidateRemotely(key);
        this.localCache.put(key, value);
    }

    public V putIfAbsent(@Nonnull K key, @Nonnull V value) {
        Object oldValue = this.localCache.putIfAbsent(key, value);
        if (oldValue == null) {
            this.invalidateRemotely(key);
        }
        return (V)oldValue;
    }

    public void remove(@Nonnull K key) {
        this.invalidateRemotely(key);
        this.localCache.remove(key);
    }

    public boolean remove(@Nonnull K key, @Nonnull V value) {
        if (this.localCache.remove(key, value)) {
            this.invalidateRemotely(key);
            return true;
        }
        return false;
    }

    public void removeAll() {
        this.invalidateRemotely();
        this.localCache.removeAll();
    }

    public boolean replace(@Nonnull K key, @Nonnull V oldValue, @Nonnull V newValue) {
        if (this.localCache.replace(key, oldValue, newValue)) {
            this.invalidateRemotely(key);
            return true;
        }
        return false;
    }

    public void addListener(@Nonnull CacheEntryListener<K, V> listener, boolean includeValues) {
        this.listenerSupport.add(listener, includeValues);
    }

    public void removeListener(@Nonnull CacheEntryListener<K, V> listener) {
        this.listenerSupport.remove(listener);
    }

    @Override
    protected ManagedCache getLocalCache() {
        return (ManagedCache)this.localCache;
    }

    private void invalidateRemotely() {
        this.listener.publishAll();
    }

    private void invalidateRemotely(@Nonnull K key) {
        this.listener.publish(key);
    }

    private static class AsyncInvalidationListener<K>
    extends MembershipAdapter
    implements MessageListener<Invalidate> {
        private final Cluster cluster;
        private final WeakReference<Cache<K, ?>> localCacheRef;
        private final UUID membershipListenerId;
        private final ITopic<Invalidate> topic;
        private final UUID topicListenerId;

        AsyncInvalidationListener(Cluster cluster, Cache<K, ?> localCache, ITopic<Invalidate> topic) {
            this.cluster = cluster;
            this.localCacheRef = new WeakReference(localCache);
            this.topic = topic;
            this.topicListenerId = topic.addMessageListener((MessageListener)this);
            this.membershipListenerId = cluster.addMembershipListener((MembershipListener)this);
        }

        public void memberAdded(MembershipEvent membershipEvent) {
            Cache localCache = (Cache)this.localCacheRef.get();
            if (localCache == null) {
                this.destroy();
                return;
            }
            localCache.removeAll();
        }

        public void onMessage(Message<Invalidate> message) {
            Cache localCache = (Cache)this.localCacheRef.get();
            if (localCache == null) {
                this.destroy();
                return;
            }
            if (!message.getPublishingMember().localMember()) {
                Invalidate msg = (Invalidate)message.getMessageObject();
                if (msg instanceof InvalidateKey) {
                    Object key = ((InvalidateKey)msg).getKey();
                    localCache.remove(key);
                } else {
                    localCache.removeAll();
                }
            }
        }

        void destroy() {
            this.cluster.removeMembershipListener(this.membershipListenerId);
            this.topic.removeMessageListener(this.topicListenerId);
        }

        void publishAll() {
            this.topic.publish((Object)InvalidateAll.INSTANCE);
        }

        void publish(K message) {
            this.topic.publish(new InvalidateKey<K>(message));
        }
    }

    private static class InvalidateKey<T>
    implements Invalidate {
        T key;

        public InvalidateKey() {
        }

        InvalidateKey(T key) {
            this.key = key;
        }

        T getKey() {
            return this.key;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.key);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            Object key = in.readObject();
            this.key = key;
        }
    }

    private static class InvalidateAll
    implements Invalidate {
        static final InvalidateAll INSTANCE = new InvalidateAll();

        @Override
        public void writeExternal(ObjectOutput out) {
        }

        @Override
        public void readExternal(ObjectInput in) {
        }
    }

    private static class DelegatingCacheEntryListener<K, V>
    implements CacheEntryListener<K, V> {
        private final CacheEntryListenerSupport<K, V> listenerSupport;

        private DelegatingCacheEntryListener(CacheEntryListenerSupport<K, V> listenerSupport) {
            this.listenerSupport = listenerSupport;
        }

        public void onAdd(@Nonnull CacheEntryEvent<K, V> event) {
            this.listenerSupport.notifyAdd(event.getKey(), event.getValue());
        }

        public void onEvict(@Nonnull CacheEntryEvent<K, V> event) {
            this.listenerSupport.notifyEvict(event.getKey(), event.getOldValue());
        }

        public void onRemove(@Nonnull CacheEntryEvent<K, V> event) {
            this.listenerSupport.notifyRemove(event.getKey(), event.getOldValue());
        }

        public void onUpdate(@Nonnull CacheEntryEvent<K, V> event) {
            this.listenerSupport.notifyUpdate(event.getKey(), event.getValue(), event.getOldValue());
        }
    }

    static interface Invalidate
    extends Externalizable {
    }
}

