package com.atlassian.cache.hazelcast;

import java.util.Map;

import com.hazelcast.map.AbstractEntryProcessor;

class GetOrInitVersionEntryProcessor<K> extends AbstractEntryProcessor<K, Long>
{
    private static GetOrInitVersionEntryProcessor<Object> INSTANCE = new GetOrInitVersionEntryProcessor<Object>();

    protected static <T> GetOrInitVersionEntryProcessor<T> getInstance()
    {
        //noinspection unchecked
        return (GetOrInitVersionEntryProcessor<T>) INSTANCE;
    }

    private GetOrInitVersionEntryProcessor()
    {
    }

    @Override
    public Object process(Map.Entry<K, Long> entry)
    {
        Long value = entry.getValue();
        if (value == null)
        {
            value = 1L;
            entry.setValue(value);
        }
        return value;
    }
}
