package com.atlassian.cache.hazelcast;

import com.hazelcast.core.IAtomicLong;

import static java.util.Objects.requireNonNull;

class CacheVersion
{

    private final IAtomicLong version;

    public CacheVersion(IAtomicLong version)
    {
        this.version = requireNonNull(version);
    }

    /**
     * Returns current cache version
     */
    public long get()
    {
        return version.get();
    }

    /**
     * Increments and then return current cache version. Atomic.
     */
    public long incrementAndGet()
    {
        return version.incrementAndGet();
    }


}