/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.hazelcast;

import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheStatisticsKey;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.hazelcast.HazelcastCacheManager;
import com.atlassian.util.concurrent.Supplier;
import com.google.common.collect.ImmutableSortedMap;
import com.hazelcast.config.MapConfig;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public abstract class ManagedHybridCacheSupport
implements ManagedCache {
    protected final HazelcastCacheManager cacheManager;
    protected final String name;

    public ManagedHybridCacheSupport(String name, HazelcastCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        this.name = name;
    }

    public Long currentExpireAfterAccessMillis() {
        return this.getManagedCache().currentExpireAfterAccessMillis();
    }

    public Long currentExpireAfterWriteMillis() {
        return this.getManagedCache().currentExpireAfterWriteMillis();
    }

    public Integer currentMaxEntries() {
        return this.getManagedCache().currentMaxEntries();
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isFlushable() {
        return this.getCacheSettings().getFlushable(true);
    }

    public boolean isLocal() {
        return false;
    }

    public boolean isReplicateAsynchronously() {
        return false;
    }

    public boolean isReplicateViaCopy() {
        return false;
    }

    public boolean updateExpireAfterAccess(long expireAfter, @Nonnull TimeUnit timeUnit) {
        return this.getManagedCache().updateExpireAfterAccess(expireAfter, timeUnit);
    }

    public boolean updateExpireAfterWrite(long expireAfter, @Nonnull TimeUnit timeUnit) {
        return this.getManagedCache().updateExpireAfterAccess(expireAfter, timeUnit);
    }

    public boolean updateMaxEntries(int newValue) {
        return this.getManagedCache().updateMaxEntries(newValue);
    }

    protected abstract ManagedCache getManagedCache();

    @Nonnull
    public SortedMap<CacheStatisticsKey, Supplier<Long>> getStatistics() {
        return ImmutableSortedMap.of();
    }

    protected MapConfig getConfig() {
        return this.cacheManager.getMapConfig(this.getHazelcastMapName());
    }

    protected CacheSettings getCacheSettings() {
        return this.cacheManager.getCacheSettings(this.getHazelcastMapName());
    }

    protected abstract String getHazelcastMapName();
}

