package com.atlassian.cache.ehcache.wrapper;

import com.atlassian.cache.CacheLoader;
import net.sf.ehcache.CacheException;

import javax.annotation.Nonnull;

/**
 * Decorates the loader of {@link com.atlassian.cache.ehcache.LoadingCache}.
 * We make sure that during the loading operation, wrapped key does not leak to the end user.
 */
public class ValueProcessorAtlassianCacheLoaderDecorator implements CacheLoader<Object, Object> {

    private final CacheLoader delegate;
    private final ValueProcessor valueProcessor;

    public ValueProcessorAtlassianCacheLoaderDecorator(final CacheLoader delegate, final ValueProcessor valueProcessor) {
        this.delegate = delegate;
        this.valueProcessor = valueProcessor;
    }

    @SuppressWarnings("unchecked")
    @Override
    @Nonnull
    public Object load(@Nonnull final Object key) throws CacheException {
        return valueProcessor.wrap(delegate.load(valueProcessor.unwrap(key)));
    }
}
