package com.atlassian.cache.ehcache.wrapper;

import javax.annotation.Nullable;

/**
 * This processor will be used for wrapping/unwrapping both values and keys within a cache.
 * It is very important to make sure the implementation is thread-safe and non-blocking. Lock usage may cause
 * severe performance hit.
 *
 * {@link #wrap(Object)} will be called with keys and values passed as parameters to the cache,
 * {@link #unwrap(Object)} will be called with the return value of the same operation.
 *
 * For example using {@link com.atlassian.cache.Cache#get(Object)} method will cause
 * the execution of {@link #wrap(Object)} with the key as parameter and {@link #unwrap(Object)} with the found value as parameter.
 *
 * @see ValueProcessorAtlassianCacheLoaderDecorator
 * @see ValueProcessorEhcacheLoaderDecorator
 */
public interface ValueProcessor {
    Object wrap(@Nullable Object o);

    Object unwrap(@Nullable Object o);
}