package com.atlassian.cache.compat.delegate;

import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.util.concurrent.NotNull;

import static com.atlassian.util.concurrent.Assertions.notNull;

/**
 * @since v1.0
 */
public class DelegatingCacheLoader<K,V> implements com.atlassian.cache.CacheLoader<K,V>
{
    private final CacheLoader<K,V> delegate;

    private DelegatingCacheLoader(CacheLoader<K, V> delegate)
    {
        this.delegate = notNull("delegate", delegate);
    }

    @Override
    public V load(@NotNull K key)
    {
        return delegate.load(key);
    }

    static <K,V> DelegatingCacheLoader<K,V> wrapCacheLoader(CacheLoader<K,V> delegate)
    {
        return (delegate != null) ? new DelegatingCacheLoader<K,V>(delegate) : null;
    }
}
