package com.atlassian.cache.compat.impl;

import com.atlassian.cache.compat.Supplier;

/**
 * A supplier that holds a strong reference to its referent.
 * Contrast with {@link WeakSupplier}
 *
 * @since v1.0
 */
public class StrongSupplier<V> implements Supplier<V>
{
    private final V referent;

    public StrongSupplier(final V referent)
    {
        this.referent = referent;
    }

    public V get()
    {
        return referent;
    }
}
