/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.impl;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.ManagedCache;
import com.atlassian.cache.Supplier;
import com.atlassian.util.concurrent.Function;
import com.atlassian.util.concurrent.ManagedLock;
import com.atlassian.util.concurrent.ManagedLocks;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class AbstractCacheManager
implements CacheManager {
    protected final ConcurrentMap<String, com.atlassian.util.concurrent.Supplier<ManagedCache>> caches = new ConcurrentHashMap<String, com.atlassian.util.concurrent.Supplier<ManagedCache>>();
    protected final Function<String, ManagedLock> cacheCreationLocks = ManagedLocks.weakManagedLockFactory();

    public Collection<Cache<?, ?>> getCaches() {
        ArrayList managedCaches = new ArrayList();
        for (com.atlassian.util.concurrent.Supplier cacheRef : this.caches.values()) {
            ManagedCache managedCache = (ManagedCache)cacheRef.get();
            if (!(managedCache instanceof Cache)) continue;
            managedCaches.add((Cache)managedCache);
        }
        return managedCaches;
    }

    public Collection<ManagedCache> getManagedCaches() {
        ArrayList<ManagedCache> managedCaches = new ArrayList<ManagedCache>();
        for (com.atlassian.util.concurrent.Supplier cacheRef : this.caches.values()) {
            ManagedCache managedCache = (ManagedCache)cacheRef.get();
            if (managedCache == null) continue;
            managedCaches.add(managedCache);
        }
        return managedCaches;
    }

    public ManagedCache getManagedCache(@NotNull String name) {
        com.atlassian.util.concurrent.Supplier cacheRef = (com.atlassian.util.concurrent.Supplier)this.caches.get(name);
        return null == cacheRef ? null : (ManagedCache)cacheRef.get();
    }

    public void flushCaches() {
        for (com.atlassian.util.concurrent.Supplier cacheRef : this.caches.values()) {
            ManagedCache managedCache = (ManagedCache)cacheRef.get();
            if (managedCache == null || !managedCache.isFlushable()) continue;
            managedCache.clear();
        }
    }

    public <K, V> Cache<K, V> getCache(@NotNull String name) {
        return this.getCache(name, null);
    }

    public <K, V> Cache<K, V> getCache(Class<?> owningClass, String name) {
        return this.getCache(AbstractCacheManager.cacheName(owningClass, name));
    }

    public <K, V> Cache<K, V> getCache(String name, Class<K> keyType, Class<V> valueType) {
        return this.getCache(name);
    }

    public <K, V> Cache<K, V> getCache(String name, CacheLoader<K, V> loader) {
        return this.getCache(name, loader, new CacheSettingsBuilder().build());
    }

    public <V> CachedReference<V> getCachedReference(String name, Supplier<V> supplier) {
        return this.getCachedReference(name, supplier, new CacheSettingsBuilder().build());
    }

    public <V> CachedReference<V> getCachedReference(Class<?> owningClass, String name, Supplier<V> supplier) {
        return this.getCachedReference(owningClass, name, supplier, new CacheSettingsBuilder().build());
    }

    public <V> CachedReference<V> getCachedReference(Class<?> owningClass, String name, Supplier<V> supplier, CacheSettings settings) {
        return this.getCachedReference(AbstractCacheManager.cacheName(owningClass, name), supplier, settings);
    }

    private static String cacheName(Class<?> owningClass, String name) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        return owningClass.getName() + "." + name;
    }

    public <K, V> Cache<K, V> getCache(String name, CacheLoader<K, V> loader, CacheSettings settings) {
        if (null == loader) {
            return (Cache)this.createSimpleCache(name, settings);
        }
        return (Cache)this.createComputingCache(name, settings, loader);
    }

    protected abstract <K, V> ManagedCache createComputingCache(String var1, CacheSettings var2, CacheLoader<K, V> var3);

    protected abstract ManagedCache createSimpleCache(String var1, CacheSettings var2);
}

