/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.buildeng.hallelujah;

import com.atlassian.buildeng.hallelujah.ClientTestCaseProvider;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MockClientTestCaseProvider
implements ClientTestCaseProvider {
    private Queue<String> testNames;
    private Queue<String> consumedTestNames;

    public MockClientTestCaseProvider(String ... testNames) {
        this(new LinkedList<String>(Arrays.asList(testNames)));
    }

    public MockClientTestCaseProvider(Queue<String> testNames) {
        this.testNames = testNames;
        this.consumedTestNames = new ConcurrentLinkedQueue<String>();
    }

    @Override
    public String getNextTestName() {
        String testName = null;
        if (this.testNames.size() > 0 && (testName = this.testNames.poll()) != null) {
            this.consumedTestNames.add(testName);
        }
        return testName;
    }

    public Queue<String> getConsumedTestNames() {
        return this.consumedTestNames;
    }

    public int numConsumedTests() {
        return this.consumedTestNames.size();
    }
}

