/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.buildeng.hallelujah;

import com.atlassian.buildeng.hallelujah.ClientTestCaseProvider;
import com.atlassian.buildeng.hallelujah.ClientTestCaseResult;
import com.atlassian.buildeng.hallelujah.ClientTestCaseResultCollector;
import com.atlassian.buildeng.hallelujah.ClientTestCaseRunner;
import org.apache.log4j.Logger;

public class HallelujahClient
implements Runnable {
    private static final Logger log = Logger.getLogger(HallelujahClient.class);
    private final ClientTestCaseRunner clientTestCaseRunner;
    private final ClientTestCaseProvider clientTestCaseProvider;
    private final ClientTestCaseResultCollector clientTestCaseResultCollector;

    public HallelujahClient(ClientTestCaseProvider clientTestCaseProvider, ClientTestCaseRunner clientTestCaseRunner, ClientTestCaseResultCollector clientTestCaseResultCollector) {
        this.clientTestCaseProvider = clientTestCaseProvider;
        this.clientTestCaseRunner = clientTestCaseRunner;
        this.clientTestCaseResultCollector = clientTestCaseResultCollector;
    }

    @Override
    public void run() {
        log.info((Object)"Hallelujah client starting");
        String testName = this.clientTestCaseProvider.getNextTestName();
        while (testName != null) {
            ClientTestCaseResult clientTestCaseResult = this.clientTestCaseRunner.runTest(testName);
            log.info((Object)clientTestCaseResult);
            this.clientTestCaseResultCollector.addResult(clientTestCaseResult);
            testName = this.clientTestCaseProvider.getNextTestName();
        }
        log.info((Object)"Hallelujah client stopping");
    }
}

