package com.atlassian.buildeng.hallelujah;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class MockClientTestCaseRunner implements ClientTestCaseRunner
{
    private Queue<String> runTests;

    public MockClientTestCaseRunner ()
    {
        runTests = new ConcurrentLinkedQueue<String>();
    }

    @Override
    public ClientTestCaseResult runTest(String testCaseName)
    {
        runTests.add(testCaseName);
        return new DefaultClientTestCaseResult(testCaseName, true);
    }

    public Queue<String> getRunTests()
    {
        return runTests;
    }

    public int numRunTests()
    {
        return runTests.size();
    }
}
