package com.atlassian.buildeng.hallelujah;

import java.util.HashMap;
import java.util.Map;

public class MockClientTestCaseResultCollector implements ClientTestCaseResultCollector
{
    private Map<String,ClientTestCaseResult> testCaseResults;

    public MockClientTestCaseResultCollector()
    {
        testCaseResults = new HashMap<String, ClientTestCaseResult>();
    }

    @Override
    public void addResult(ClientTestCaseResult clientTestCaseResult)
    {
        testCaseResults.put(clientTestCaseResult.getName(), clientTestCaseResult);
    }

    @Override
    public boolean hasResultsForTest(String testCaseName)
    {
        return testCaseResults.containsKey(testCaseName);
    }
}
