package com.atlassian.buildeng.hallelujah;

public class HallelujahClient implements Runnable
{
    private static final org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(HallelujahClient.class);

    private final ClientTestCaseRunner clientTestCaseRunner;
    private final ClientTestCaseProvider clientTestCaseProvider;
    private final ClientTestCaseResultCollector clientTestCaseResultCollector;

    public HallelujahClient(ClientTestCaseProvider clientTestCaseProvider, ClientTestCaseRunner clientTestCaseRunner, ClientTestCaseResultCollector clientTestCaseResultCollector)
    {
        this.clientTestCaseProvider = clientTestCaseProvider;
        this.clientTestCaseRunner = clientTestCaseRunner;
        this.clientTestCaseResultCollector = clientTestCaseResultCollector;
    }

    public void run ()
    {
        log.info("Hallelujah client starting");

        String testName = clientTestCaseProvider.getNextTestName();
        while (testName != null)
        {
            ClientTestCaseResult clientTestCaseResult = clientTestCaseRunner.runTest(testName);
            log.info(clientTestCaseResult);

            clientTestCaseResultCollector.addResult(clientTestCaseResult);

            testName = clientTestCaseProvider.getNextTestName();
        }

        log.info("Hallelujah client stopping");
    }
}
