package com.atlassian.buildeng.hallelujah;

public class DefaultClientTestCaseResult implements ClientTestCaseResult
{
    private final String name;
    private boolean passed;

    public DefaultClientTestCaseResult (String name, boolean passed)
    {
        this.name = name;
        this.passed = passed;
    }

    public String toString ()
    {
        String prettyString;

        prettyString = name + ": " + (passed ? "PASSED" : "FAILED");

        return prettyString;
    }

    @Override
    public boolean passed()
    {
        return passed;
    }

    @Override
    public String getName()
    {
        return name;
    }
}
