package com.atlassian.buildeng.hallelujah.api.server;

import com.atlassian.buildeng.hallelujah.api.model.TestCaseName;
import com.atlassian.buildeng.hallelujah.api.model.TestCaseResult;

/**
 * Listener for various server events. Returning false on {@link #onResultReceived(ServerTestCaseResultCollector, ServerTestCaseProvider, com.atlassian.buildeng.hallelujah.api.model.TestCaseResult)}
 * will cause the received {@link TestCaseResult} <em>not</em> to be added to the {@link ServerTestCaseResultCollector}.
 */
public interface ServerListener
{
    void onFinish(ServerTestCaseProvider serverTestCaseProvider, ServerTestCaseResultCollector serverTestCaseResultCollector);
    void onStart(ServerTestCaseProvider serverTestCaseProvider, ServerTestCaseResultCollector serverTestCaseResultCollector);
    void onServerTimeout(ServerTestCaseProvider serverTestCaseProvider, ServerTestCaseResultCollector serverTestCaseResultCollector);
    void onNewTestAdded(ServerTestCaseResultCollector serverTestCaseResultCollector, ServerTestCaseProvider serverTestCaseProvider, TestCaseName testCaseName);
    boolean onResultReceived(ServerTestCaseResultCollector serverTestCaseResultCollector, ServerTestCaseProvider serverTestCaseProvider, TestCaseResult testCaseResult);
}
