package com.atlassian.buildeng.hallelujah.api.model;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;

@XmlRootElement
public class TestCaseResult implements Serializable
{
    @XmlElement
    public TestCaseName testCaseName;

    @XmlElement
    public boolean passed;

    @XmlElement
    public boolean ignored;

    @XmlElement
    public double duration;

    @XmlElement
    public TestCaseFailure failure;

    @XmlElement
    public TestCaseError error;

    @XmlElement
    public String runnerId;

    public TestCaseResult()
    {

    }

    public TestCaseResult(TestCaseName testCaseName, boolean passed, double duration)
    {
        this(testCaseName, passed, duration, null, null);
    }

    public TestCaseResult(TestCaseName testCaseName, boolean passed, double duration, TestCaseFailure failure)
    {
        this(testCaseName, passed, duration, failure, null);
    }

    public TestCaseResult(TestCaseName testCaseName, boolean passed, double duration, TestCaseError error)
    {
        this(testCaseName, passed, duration, null, error);
    }

    public TestCaseResult(TestCaseName testCaseName, boolean passed, double duration, TestCaseFailure failure, TestCaseError error)
    {
       this(testCaseName, passed, false, duration, failure, error);
    }

    public TestCaseResult(TestCaseName testCaseName, boolean passed, boolean ignored, double duration, TestCaseFailure failure, TestCaseError error)
    {
        this.testCaseName = testCaseName;
        this.passed = passed;
        this.duration = duration;
        this.failure = failure;
        this.error = error;
        this.ignored = ignored;
    }

    public void setRunnerId(String runnerId)
    {
        this.runnerId = runnerId;
    }

    @Override
    public String toString()
    {
        return testCaseName.fullName() + ": " + (passed ? "PASSED" : "FAILED");
    }
}