package com.atlassian.buildeng.hallelujah.api.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlElement;
import java.io.Serializable;

@XmlRootElement
public class TestCaseName implements Serializable
{
    @XmlElement
    public String className;

    @XmlElement
    public String methodName;

    public TestCaseName()
    {

    }

    public TestCaseName(String className, String methodName)
    {
        this.className = className;
        this.methodName = methodName;
    }

    public String fullName()
    {
        String fullName = className;

        if (methodName != null && methodName.length() > 0)
        {
            fullName += "#" + methodName;
        }

        return fullName;
    }

    @Override
    public String toString()
    {
        return fullName();
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        TestCaseName that = (TestCaseName) o;

        if (className != null ? !className.equals(that.className) : that.className != null) return false;
        if (methodName != null ? !methodName.equals(that.methodName) : that.methodName != null) return false;

        return true;
    }

    @Override
    public int hashCode()
    {
        int result = className != null ? className.hashCode() : 0;
        result = 31 * result + (methodName != null ? methodName.hashCode() : 0);
        return result;
    }
}
