/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.browsers;

import com.atlassian.browsers.OsValidator;
import com.atlassian.browsers.ProcessRunner;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

class XvfbManager {
    String xvfbExecutable = System.getProperty("xvfb.executable", "Xvfb");
    boolean xauthEnabled = Boolean.parseBoolean(System.getProperty("xvfb.xauth.enable", "false"));
    String xauthExecutable = System.getProperty("xvfb.xauth.executable", "xauth");
    String xauthProtocol = System.getProperty("xvfb.xauth.protocol", ".");
    static final int DEFAULT_DISPLAY_NUMBER = 20;
    static final int MAX_PORT_TRIES = 10;
    String display = System.getProperty("xvfb.display", ":20");
    String options = System.getProperty("xvfb.options");
    boolean logOutput = Boolean.parseBoolean(System.getProperty("xvfb.log.enabled", "true"));
    File baseTmpDir;
    private File authenticationFile;
    private Process xfvbProcess;

    public XvfbManager(File baseTmpDir) {
        this.baseTmpDir = baseTmpDir;
    }

    public static boolean isSupportedOS() {
        return OsValidator.isUnix();
    }

    public void start() {
        List<String> optionsList = this.parseXvfbOptions();
        System.out.println("Starting Xvfb...");
        this.display = this.detectUsableDisplay();
        System.out.println("Using display: " + this.display);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.xvfbExecutable);
        cmd.add(this.display);
        cmd.addAll(optionsList);
        System.out.println("Using options: " + optionsList);
        ProcessBuilder procBuilder = new ProcessBuilder(cmd);
        this.authenticationFile = null;
        if (this.xauthEnabled) {
            this.authenticationFile = this.setupXauthority();
            procBuilder.environment().put("XAUTHORITY", this.authenticationFile.getAbsolutePath());
        }
        this.writeDisplayProperties();
        File logFile = null;
        if (this.logOutput) {
            logFile = new File(this.baseTmpDir, "xvfb.log");
            System.out.println("Redirecting output to: " + logFile.getPath());
        }
        this.xfvbProcess = ProcessRunner.runProcessInBackground(procBuilder, logFile);
        System.out.println("Waiting till xvfb is up...");
        while (!this.isDisplayInUse(this.display)) {
            try {
                System.out.println('.');
                System.out.flush();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println("xvfb is up!");
    }

    @VisibleForTesting
    List<String> parseXvfbOptions() {
        String xvfbHelp = this.getXvfbHelp();
        boolean supportsListen = xvfbHelp.contains("\n-listen");
        if (this.options != null) {
            List<String> optionsList = Arrays.asList(this.options.split(","));
            if (supportsListen && Collections.indexOfSubList(optionsList, Arrays.asList("-listen", "tcp")) == -1) {
                System.out.println("WARNING: '-listen,tcp' not set. Newer versions of Xvfb might hang without this option. Recommend adding to xvfb.options in pom.xml.");
            }
            return optionsList;
        }
        if (supportsListen) {
            return Arrays.asList("-once", "-listen", "tcp");
        }
        return Arrays.asList("-once");
    }

    private String getXvfbHelp() {
        String output;
        Process proc;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.xvfbExecutable);
        cmd.add("-help");
        ProcessBuilder procBuilder = new ProcessBuilder(cmd).redirectErrorStream(true);
        try {
            proc = procBuilder.start();
            output = IOUtils.toString((InputStream)proc.getInputStream());
            if (proc.waitFor() != 0) {
                System.out.println(output);
            }
        }
        catch (IOException e) {
            this.missingXvfb();
            throw new RuntimeException("Unable to execute Xvfb. Please ensure it is installed.", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        if (proc.exitValue() != 0) {
            this.missingXvfb();
            throw new RuntimeException("Unable to execute Xvfb. Please ensure it is installed.");
        }
        return output;
    }

    private void missingXvfb() {
        System.out.println("*************************************************************");
        System.out.println("Unable to execute Xvfb. Please ensure it is installed.");
        System.out.println("*************************************************************");
    }

    public File getXAuthenticationFile() {
        return this.authenticationFile;
    }

    public String getDisplay() {
        return this.display;
    }

    public void stop() {
        if (this.authenticationFile != null) {
            this.authenticationFile.delete();
        }
        if (this.xfvbProcess != null) {
            this.xfvbProcess.destroy();
        }
    }

    private void writeDisplayProperties() {
        try {
            String text = "DISPLAY='" + this.display + "'\n";
            if (this.xauthEnabled) {
                text = text + "XAUTHORITY='" + this.authenticationFile.getCanonicalPath() + "'\n";
            }
            File propFile = new File(this.baseTmpDir, "xvfb.env.properties");
            FileUtils.writeStringToFile((File)propFile, (String)text);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to save display properties", e);
        }
    }

    private String createCookie() {
        byte[] bytes = new byte[16];
        new Random().nextBytes(bytes);
        BigInteger cookie = new BigInteger(bytes);
        String cookieHex = cookie.abs().toString(16);
        int padding = 32 - cookieHex.length();
        for (int i = 0; i < padding; ++i) {
            cookieHex = "0" + cookieHex;
        }
        return cookieHex;
    }

    private File setupXauthority() {
        File authenticationFile = new File(this.baseTmpDir, "Xvfb.Xauthority");
        System.out.println("Using Xauthority file: " + authenticationFile.getPath());
        String cookie = this.createCookie();
        ProcessBuilder procBuilder = new ProcessBuilder(this.xauthExecutable, "add", this.display, this.xauthProtocol, cookie);
        procBuilder.environment().put("XAUTHORITY", authenticationFile.getAbsolutePath());
        ProcessRunner.runProcess(procBuilder);
        if (!authenticationFile.exists()) {
            throw new RuntimeException("It appears that 'xauth' failed to create the Xauthority file: " + authenticationFile.getPath());
        }
        return authenticationFile;
    }

    private String detectUsableDisplay() {
        int startPort = this.displayPortToInt(this.display);
        boolean found = false;
        for (int n = startPort; n < startPort + 10; ++n) {
            String d = ":" + n;
            if (this.isDisplayInUse(d)) continue;
            return d;
        }
        throw new RuntimeException("Could not find a usable display");
    }

    private int displayPortToInt(String display) {
        return Integer.parseInt(display.substring(display.indexOf(":") + 1));
    }

    private int decodeDisplayPort(String display) {
        return 6000 + Integer.parseInt(display.substring(display.indexOf(":") + 1));
    }

    @VisibleForTesting
    boolean isDisplayInUse(String display) {
        int port = this.decodeDisplayPort(display);
        try {
            new Socket("localhost", port);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

