/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.browsers;

import com.atlassian.browsers.AbstractInstallConfigurator;
import com.atlassian.browsers.BrowserConfig;
import com.atlassian.browsers.BrowserType;
import com.atlassian.browsers.InstallConfigurator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;

public final class MultiBrowserConfigurator
extends AbstractInstallConfigurator {
    private final Map<BrowserType, InstallConfigurator> configurators;

    public MultiBrowserConfigurator(@Nonnull Map<BrowserType, InstallConfigurator> configurators) {
        this.configurators = ImmutableMap.copyOf(configurators);
    }

    @Override
    public void setupBrowser(@Nonnull BrowserConfig browserConfig) {
        InstallConfigurator configurator = this.configurators.get((Object)browserConfig.getBrowserType());
        if (configurator != null) {
            configurator.setupBrowser(browserConfig);
        }
    }

    public static class Builder {
        private final Map<BrowserType, InstallConfigurator> configurators = Maps.newHashMap();

        public Builder addConfigurator(BrowserType type, InstallConfigurator configurator) {
            this.configurators.put(type, configurator);
            return this;
        }

        public MultiBrowserConfigurator build() {
            return new MultiBrowserConfigurator(this.configurators);
        }
    }
}

