/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.browsers;

import com.atlassian.browsers.BrowserConfig;
import com.atlassian.browsers.BrowserType;
import com.atlassian.browsers.BuiltInConfigurator;
import com.atlassian.browsers.OS;
import com.atlassian.browsers.OsValidator;
import com.atlassian.browsers.Utils;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum BrowserInstaller {
    FIREFOX_OSX(BrowserType.FIREFOX, OS.OSX, "Contents/MacOS/firefox-bin"),
    CHROME_OSX(BrowserType.CHROME, OS.OSX, "Contents/MacOS/Google Chrome"),
    FIREFOX_LINUX(BrowserType.FIREFOX, OS.LINUX, "firefox-bin"),
    CHROME_LINUX(BrowserType.CHROME, OS.LINUX, "chrome"),
    FIREFOX_LINUX64(BrowserType.FIREFOX, OS.LINUX64, "firefox-bin"),
    CHROME_LINUX64(BrowserType.CHROME, OS.LINUX64, "chrome"),
    FIREFOX_WINDOWS(BrowserType.FIREFOX, OS.WINDOWS, "firefox.exe"),
    IE_WINDOWS(BrowserType.IE, OS.WINDOWS, null);

    private static final Logger log;
    private static final String PACKAGE_MANIFEST = "profile.package";
    private static final String BROWSER_MANIFEST = "browser.package";
    private final BrowserType browser;
    private final OS os;
    private final String binaryPath;

    private BrowserInstaller(@Nullable BrowserType browser, OS os, String binaryPath) {
        this.browser = (BrowserType)((Object)Preconditions.checkNotNull((Object)((Object)browser), (Object)"browser"));
        this.os = (OS)((Object)Preconditions.checkNotNull((Object)((Object)os), (Object)"os"));
        this.binaryPath = binaryPath;
    }

    public BrowserType getBrowser() {
        return this.browser;
    }

    @Nullable
    public OS getOS() {
        return this.os;
    }

    public String getOsDirName() {
        return this.os == null ? "ALL" : this.os.getName();
    }

    @Nullable
    public String getBinaryPath() {
        return this.binaryPath;
    }

    public static BrowserInstaller typeOf(String browserStr) {
        OS os = OS.getType();
        BrowserType browserType = BrowserType.typeOf(browserStr);
        for (BrowserInstaller installer : BrowserInstaller.values()) {
            if (!installer.getOS().getName().equals(os.getName()) || !installer.getBrowser().equals((Object)browserType) || !browserStr.equals(installer.getBrowser().getName()) && !browserStr.matches("^" + installer.getBrowser().getName() + "-[0-9.]+$")) continue;
            log.debug("Using {}", (Object)installer);
            return installer;
        }
        log.info("There are no browser installers for browser string {}", (Object)browserStr);
        return null;
    }

    public void install(File destination, BuiltInConfigurator installConfigurator) {
        String browserName = this.browser.getName();
        String binaryPath = this.getBinaryPath();
        String osDirName = this.getOsDirName();
        String profileName = browserName + "-profile";
        String browserResource = "/" + browserName + "-" + osDirName + ".zip";
        String profileResource = "/" + profileName + ".zip";
        String osProfileResource = "/" + profileName + "-" + osDirName + ".zip";
        try {
            File browserDir = this.extractBrowser(destination, browserResource);
            File browserBinary = this.getBrowserBinary(binaryPath, browserDir);
            File browserProfile = this.extractProfile(destination, profileResource, osProfileResource);
            BrowserConfig browserConfig = new BrowserConfig(browserDir, browserBinary, browserProfile, this.browser);
            installConfigurator.setupBrowser(browserConfig);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File extractProfile(File destination, String profileResource, String osProfileResource) throws IOException {
        if (Utils.resourceExists(osProfileResource)) {
            return this.extractZipProfileAndLog(destination, osProfileResource);
        }
        if (Utils.resourceExists(profileResource)) {
            return this.extractZipProfileAndLog(destination, profileResource);
        }
        log.info("Profile for {}:{} is not supported", (Object)this.getBrowser().name(), (Object)this.getOsDirName());
        return null;
    }

    private File extractZipProfileAndLog(File destination, String osProfileResource) throws IOException {
        File profileDir = Utils.extractZip(destination, osProfileResource);
        log.info("Installing {}", (Object)FileUtils.readFileToString((File)new File(profileDir, PACKAGE_MANIFEST)));
        return profileDir;
    }

    private File extractBrowser(File destination, String browserResource) throws IOException {
        if (!Utils.resourceExists(browserResource)) {
            log.info("Browser {}:{} is not supported", (Object)this.getBrowser().name(), (Object)this.getOsDirName());
            return null;
        }
        File browserDir = Utils.extractZip(destination, browserResource);
        log.info("Installing {}", (Object)FileUtils.readFileToString((File)new File(browserDir, BROWSER_MANIFEST)));
        return browserDir;
    }

    private File getBrowserBinary(String binaryPath, File browserDir) throws IOException {
        if (browserDir == null) {
            return null;
        }
        File browserBinary = new File(browserDir, binaryPath);
        if (!OsValidator.isWindows()) {
            Utils.make755(browserBinary);
        }
        return browserBinary;
    }

    static {
        log = LoggerFactory.getLogger(BrowserInstaller.class);
    }
}

