/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source.yaml;

import com.atlassian.braid.BraidContext;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.java.util.BraidMaps;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.mapper.Mapper;
import com.atlassian.braid.mapper.Mappers;
import com.atlassian.braid.source.GraphQLRemoteRetriever;
import com.atlassian.braid.source.GraphQLRemoteSchemaSource;
import com.atlassian.braid.source.yaml.RestRemoteRetriever;
import com.atlassian.braid.source.yaml.RestRemoteSchemaSource;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

public class YamlRemoteSchemaSourceFactory {
    public static <C extends BraidContext> RestRemoteSchemaSource<C> createRestSource(Reader source, RestRemoteRetriever<C> restRemoteRetriever) {
        Map<String, Object> m = YamlRemoteSchemaSourceFactory.loadYamlMap(source);
        SchemaNamespace namespace = SchemaNamespace.of((String)m.get("name"));
        Supplier<Reader> schema = () -> new StringReader((String)m.get("schema"));
        Map<String, RestRemoteSchemaSource.RootField> rootFields = BraidMaps.get(m, "rootFields").map(BraidObjects::cast).orElse(Collections.emptyMap()).entrySet().stream().map(e -> {
            String fieldName = (String)e.getKey();
            Map params = (Map)e.getValue();
            Mapper mapping = Mappers.fromYamlList((List)BraidObjects.cast(params.get("responseMapping")));
            return new RestRemoteSchemaSource.RootField(fieldName, (String)BraidObjects.cast(params.get("uri")), mapping);
        }).collect(Collectors.toMap(f -> f.name, f -> f));
        return new RestRemoteSchemaSource<C>(namespace, schema, restRemoteRetriever, rootFields, YamlRemoteSchemaSourceFactory.buildLinks(m), YamlRemoteSchemaSourceFactory.buildTopLevelFields(m));
    }

    public static <C extends BraidContext> SchemaSource<C> createGraphQLSource(Reader source, GraphQLRemoteRetriever<C> graphQLRemoteRetriever) {
        Map<String, Object> m = YamlRemoteSchemaSourceFactory.loadYamlMap(source);
        SchemaNamespace namespace = SchemaNamespace.of((String)m.get("name"));
        Supplier<Reader> schema = () -> new StringReader((String)m.get("schema"));
        return new GraphQLRemoteSchemaSource<C>(namespace, schema, graphQLRemoteRetriever, YamlRemoteSchemaSourceFactory.buildLinks(m), YamlRemoteSchemaSourceFactory.buildTopLevelFields(m));
    }

    private static Map<String, Object> loadYamlMap(Reader source) {
        return (Map)BraidObjects.cast(new Yaml().load(source));
    }

    private static String[] buildTopLevelFields(Map<String, Object> m) {
        return BraidMaps.get(m, "topLevelFields").map(BraidObjects::cast).orElse(Collections.emptyList()).toArray(new String[0]);
    }

    private static List<Link> buildLinks(Map<String, Object> m) {
        SchemaNamespace fromNamespace = SchemaNamespace.of((String)YamlRemoteSchemaSourceFactory.getOrThrow(m, "name"));
        return BraidMaps.get(m, "links").map(BraidObjects::cast).map(links -> YamlRemoteSchemaSourceFactory.buildLinks(fromNamespace, links)).orElse(Collections.emptyList());
    }

    private static List<Link> buildLinks(SchemaNamespace fromNamespace, List<Map<String, Map<String, Object>>> links) {
        return links.stream().map(l -> YamlRemoteSchemaSourceFactory.buildLink(fromNamespace, l)).collect(Collectors.toList());
    }

    private static Link buildLink(SchemaNamespace fromNamespace, Map<String, Map<String, Object>> linkMap) {
        Map from = (Map)YamlRemoteSchemaSourceFactory.getOrThrow(linkMap, "from");
        Map to = (Map)YamlRemoteSchemaSourceFactory.getOrThrow(linkMap, "to");
        Link.LinkBuilder linkBuilder = YamlRemoteSchemaSourceFactory.buildFrom(fromNamespace, from);
        linkBuilder = YamlRemoteSchemaSourceFactory.buildTo(linkBuilder, to);
        if (YamlRemoteSchemaSourceFactory.getReplaceFromField(linkMap)) {
            linkBuilder.replaceFromField();
        }
        BraidMaps.get(to, "argument").ifPresent(linkBuilder::argument);
        BraidMaps.get(to, "nullable").map(Boolean::valueOf).ifPresent(linkBuilder::setNullable);
        return linkBuilder.build();
    }

    private static Link.LinkBuilder buildFrom(SchemaNamespace fromNamespace, Map<String, String> from) {
        String fromField = (String)YamlRemoteSchemaSourceFactory.getOrThrow(from, "field");
        return Link.from(fromNamespace, (String)YamlRemoteSchemaSourceFactory.getOrThrow(from, "type"), fromField, BraidMaps.get(from, "fromField").orElse(fromField));
    }

    private static Link.LinkBuilder buildTo(Link.LinkBuilder builder, Map<String, String> to) {
        return builder.to(SchemaNamespace.of((String)YamlRemoteSchemaSourceFactory.getOrThrow(to, "namespace")), (String)YamlRemoteSchemaSourceFactory.getOrThrow(to, "type"), (String)YamlRemoteSchemaSourceFactory.getOrThrow(to, "field"), BraidMaps.get(to, "variableField").orElse(null));
    }

    private static <T> T getOrThrow(Map<String, ?> map, String key) {
        return (T)BraidMaps.get(map, key).map(BraidObjects::cast).orElseThrow(IllegalStateException::new);
    }

    public static boolean getReplaceFromField(Map<String, Map<String, Object>> link) {
        return BraidMaps.get(link.get("from"), "replaceFromField").map(BraidObjects::cast).orElse(false);
    }
}

