/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.java.util.BraidMaps;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.mapper.CopyListOperation;
import com.atlassian.braid.mapper.CopyMapOperation;
import com.atlassian.braid.mapper.CopyOperation;
import com.atlassian.braid.mapper.ListOperation;
import com.atlassian.braid.mapper.MapOperation;
import com.atlassian.braid.mapper.Mapper;
import com.atlassian.braid.mapper.MapperException;
import com.atlassian.braid.mapper.MapperOperation;
import com.atlassian.braid.mapper.Mappers;
import com.atlassian.braid.mapper.PutOperation;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

final class YamlMappers {
    YamlMappers() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Map<String, Object> load(Supplier<Reader> yaml) {
        try (Reader reader = yaml.get();){
            Map map = (Map)new Yaml().loadAs(reader, Map.class);
            return map;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static List<MapperOperation> toMapperOperations(Map<String, Object> yamlAsMap) {
        return yamlAsMap.entrySet().stream().map(YamlMappers::operationFromEntry).collect(Collectors.toList());
    }

    private static MapperOperation operationFromEntry(Map.Entry<String, Object> entry) {
        String sourceKey = entry.getKey();
        OperationNameAndProps opsAndProps = YamlMappers.toOperationNameAndProps(entry.getValue());
        return opsAndProps.getOperation().map(String::toUpperCase).map(YamlOperationType::valueOf).map(yot -> yot.apply(sourceKey, opsAndProps.getProperties())).orElseThrow(() -> new MapperException("Could not find operation with name '%s'", opsAndProps.operation));
    }

    private static OperationNameAndProps toOperationNameAndProps(Object object) {
        if (object instanceof String) {
            return new OperationNameAndProps(String.valueOf(object), Collections.emptyMap());
        }
        if (object instanceof Map) {
            Map props = (Map)BraidObjects.cast(object);
            return new OperationNameAndProps(YamlMappers.getOperationName(props), props);
        }
        return new OperationNameAndProps(null, Collections.emptyMap());
    }

    private static String getOperationName(Map<String, Object> props) {
        return BraidMaps.get(props, "op").map(String::valueOf).orElseThrow(() -> new MapperException("Could not find attribute (%s) for configuration: %s", "op", props));
    }

    private static String getTargetKey(Map<String, Object> props, String defaultValue) {
        return BraidMaps.get(props, "target").map(String::valueOf).orElse(defaultValue);
    }

    private static Mapper getMapper(Map<String, Object> props) {
        return BraidMaps.get(props, "mapper").map(BraidObjects::cast).map(Mappers::fromYamlMap).orElseGet(Mappers::mapper);
    }

    static class OperationNameAndProps {
        private final String operation;
        private final Map<String, Object> properties;

        OperationNameAndProps(String operation, Map<String, Object> properties) {
            this.operation = operation;
            this.properties = Objects.requireNonNull(properties);
        }

        Optional<String> getOperation() {
            return Optional.ofNullable(this.operation);
        }

        Map<String, Object> getProperties() {
            return this.properties;
        }
    }

    static enum YamlOperationType implements BiFunction<String, Map<String, Object>, MapperOperation>
    {
        COPY((key, props) -> new CopyOperation((String)key, YamlMappers.getTargetKey(props, key), () -> null, Function.identity())),
        PUT((key, props) -> new PutOperation((String)key, props.get("value"))),
        COPYLIST((key, props) -> new CopyListOperation((String)key, YamlMappers.getTargetKey(props, key), YamlMappers.getMapper(props))),
        LIST((key, props) -> new ListOperation((String)key, __ -> true, YamlMappers.getMapper(props))),
        MAP((key, props) -> new MapOperation((String)key, __ -> true, YamlMappers.getMapper(props))),
        COPYMAP((key, props) -> new CopyMapOperation((String)key, YamlMappers.getTargetKey(props, key), YamlMappers.getMapper(props)));

        final BiFunction<String, Map<String, Object>, MapperOperation> getOperation;

        private YamlOperationType(BiFunction<String, Map<String, Object>, MapperOperation> getOperation) {
            this.getOperation = getOperation;
        }

        @Override
        public MapperOperation apply(String key, Map<String, Object> props) {
            return this.getOperation.apply(key, props);
        }
    }
}

