/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import graphql.schema.GraphQLSchema;
import java.util.Map;
import java.util.Objects;
import org.dataloader.BatchLoader;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;

public class Braid {
    private final GraphQLSchema schema;
    private final Map<String, BatchLoader> batchLoaders;

    public Braid(GraphQLSchema schema, Map<String, BatchLoader> batchLoaders) {
        this.schema = Objects.requireNonNull(schema);
        this.batchLoaders = Objects.requireNonNull(batchLoaders);
    }

    public GraphQLSchema getSchema() {
        return this.schema;
    }

    public DataLoaderRegistry newDataLoaderRegistry() {
        DataLoaderRegistry registry = new DataLoaderRegistry();
        this.batchLoaders.forEach((key, loader) -> registry.register(key, new DataLoader(loader)));
        return registry;
    }
}

