/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.graphql.instrumenation;

import graphql.ExecutionResult;
import graphql.ExecutionResultImpl;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.NoOpInstrumentation;
import graphql.execution.instrumentation.dataloader.DataLoaderDispatcherInstrumentationOptions;
import graphql.execution.instrumentation.parameters.InstrumentationDataFetchParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionParameters;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldCompleteParameters;
import graphql.language.Field;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.dataloader.stats.Statistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BraidDataLoaderDispatcherInstrumentation
extends NoOpInstrumentation {
    private static final Logger log = LoggerFactory.getLogger(BraidDataLoaderDispatcherInstrumentation.class);
    private final DataLoaderRegistry dataLoaderRegistry;
    private final DataLoaderDispatcherInstrumentationOptions options;

    public BraidDataLoaderDispatcherInstrumentation(DataLoaderRegistry dataLoaderRegistry) {
        this(dataLoaderRegistry, DataLoaderDispatcherInstrumentationOptions.newOptions());
    }

    public BraidDataLoaderDispatcherInstrumentation(DataLoaderRegistry dataLoaderRegistry, DataLoaderDispatcherInstrumentationOptions options) {
        this.dataLoaderRegistry = Objects.requireNonNull(dataLoaderRegistry);
        this.options = Objects.requireNonNull(options);
    }

    public InstrumentationState createState() {
        return new BraidDispatcherInstrumentationState();
    }

    private void dispatch() {
        log.debug("Dispatching data loaders ({})", (Object)this.dataLoaderRegistry.getKeys());
        this.dataLoaderRegistry.dispatchAll();
    }

    public InstrumentationContext<CompletableFuture<ExecutionResult>> beginDataFetchDispatch(InstrumentationDataFetchParameters parameters) {
        return BraidDataLoaderDispatcherInstrumentation.onEndDispatch(this::dispatch);
    }

    public InstrumentationContext<Map<String, List<Field>>> beginFields(InstrumentationExecutionStrategyParameters parameters) {
        BraidDispatcherInstrumentationState state = (BraidDispatcherInstrumentationState)parameters.getInstrumentationState();
        if (!state.fieldsEnteredOnce()) {
            state.enterFields();
            return BraidDataLoaderDispatcherInstrumentation.onEndDispatchIfNeeded(this::dispatch, state);
        }
        return BraidDataLoaderDispatcherInstrumentation.onEndNoop();
    }

    public InstrumentationContext<CompletableFuture<ExecutionResult>> beginCompleteFieldList(InstrumentationFieldCompleteParameters parameters) {
        BraidDispatcherInstrumentationState braidDispatcherInstrumentationState = (BraidDispatcherInstrumentationState)parameters.getInstrumentationState();
        braidDispatcherInstrumentationState.enterList();
        return BraidDataLoaderDispatcherInstrumentation.composed((__, ___) -> braidDispatcherInstrumentationState.exitList(), BraidDataLoaderDispatcherInstrumentation.onEndDispatchIfNeeded(this::dispatch, braidDispatcherInstrumentationState));
    }

    public CompletableFuture<ExecutionResult> instrumentExecutionResult(ExecutionResult executionResult, InstrumentationExecutionParameters parameters) {
        if (!this.options.isIncludeStatistics()) {
            return CompletableFuture.completedFuture(executionResult);
        }
        Map currentExt = executionResult.getExtensions();
        LinkedHashMap<String, Map<Object, Object>> statsMap = new LinkedHashMap<String, Map<Object, Object>>();
        statsMap.putAll(currentExt == null ? Collections.emptyMap() : currentExt);
        Map<Object, Object> dataLoaderStats = this.buildStatsMap();
        statsMap.put("dataloader", dataLoaderStats);
        log.debug("Data loader stats : {}", dataLoaderStats);
        return CompletableFuture.completedFuture(new ExecutionResultImpl(executionResult.getData(), executionResult.getErrors(), statsMap));
    }

    private Map<Object, Object> buildStatsMap() {
        Statistics allStats = this.dataLoaderRegistry.getStatistics();
        LinkedHashMap<Object, Object> statsMap = new LinkedHashMap<Object, Object>();
        statsMap.put("overall-statistics", allStats.toMap());
        LinkedHashMap<String, Map> individualStatsMap = new LinkedHashMap<String, Map>();
        for (String dlKey : this.dataLoaderRegistry.getKeys()) {
            DataLoader dl = this.dataLoaderRegistry.getDataLoader(dlKey);
            Statistics statistics = dl.getStatistics();
            individualStatsMap.put(dlKey, statistics.toMap());
        }
        statsMap.put("individual-statistics", individualStatsMap);
        return statsMap;
    }

    private static <T> InstrumentationContext<T> onEndNoop() {
        return (__, ___) -> {};
    }

    private static <T> InstrumentationContext<T> onEndDispatch(Runnable dispatcher) {
        return new DispatchIfNeededInstrumentationContext(dispatcher, () -> true);
    }

    private static <T> InstrumentationContext<T> onEndDispatchIfNeeded(Runnable dispatcher, BraidDispatcherInstrumentationState state) {
        return new DispatchIfNeededInstrumentationContext(dispatcher, () -> !state.isInList());
    }

    @SafeVarargs
    private static <T> InstrumentationContext<T> composed(InstrumentationContext<T> ... contexts) {
        return new ComposedInstrumentationContext(Arrays.asList(contexts));
    }

    private static final class BraidDispatcherInstrumentationState
    implements InstrumentationState {
        private final Deque<Boolean> listTracker = new ArrayDeque<Boolean>();
        private final AtomicBoolean fieldsEnteredOnce = new AtomicBoolean();

        private BraidDispatcherInstrumentationState() {
        }

        private void enterFields() {
            this.fieldsEnteredOnce.set(true);
        }

        private boolean fieldsEnteredOnce() {
            return this.fieldsEnteredOnce.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enterList() {
            BraidDispatcherInstrumentationState braidDispatcherInstrumentationState = this;
            synchronized (braidDispatcherInstrumentationState) {
                this.listTracker.push(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void exitList() {
            BraidDispatcherInstrumentationState braidDispatcherInstrumentationState = this;
            synchronized (braidDispatcherInstrumentationState) {
                this.listTracker.poll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isInList() {
            BraidDispatcherInstrumentationState braidDispatcherInstrumentationState = this;
            synchronized (braidDispatcherInstrumentationState) {
                return !this.listTracker.isEmpty() ? this.listTracker.peek() : false;
            }
        }

        public String toString() {
            return "isInList=" + this.isInList() + ", fieldsEnteredOnce=" + this.fieldsEnteredOnce();
        }
    }

    private static class DispatchIfNeededInstrumentationContext<T>
    implements InstrumentationContext<T> {
        private final Supplier<Boolean> shouldDispatch;
        private final Runnable dispatcher;

        private DispatchIfNeededInstrumentationContext(Runnable dispatcher, Supplier<Boolean> shouldDispatch) {
            this.shouldDispatch = Objects.requireNonNull(shouldDispatch);
            this.dispatcher = Objects.requireNonNull(dispatcher);
        }

        public void onEnd(T result, Throwable t) {
            if (this.shouldDispatch.get().booleanValue()) {
                this.dispatcher.run();
            }
        }
    }

    private static class ComposedInstrumentationContext<T>
    implements InstrumentationContext<T> {
        private final List<InstrumentationContext<T>> contexts;

        private ComposedInstrumentationContext(List<InstrumentationContext<T>> contexts) {
            this.contexts = Objects.requireNonNull(contexts);
        }

        public void onEnd(T result, Throwable t) {
            this.contexts.forEach(c -> c.onEnd(result, t));
        }
    }
}

