/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.BraidContext;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.mapper.Mapper;
import com.atlassian.braid.mapper.Mappers;
import com.atlassian.braid.source.GraphQLRemoteRetriever;
import com.atlassian.braid.source.GraphQLRemoteSchemaSource;
import com.atlassian.braid.source.RestRemoteRetriever;
import com.atlassian.braid.source.RestRemoteSchemaSource;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

public class YamlRemoteSchemaSourceFactory {
    public static <C extends BraidContext> RestRemoteSchemaSource<C> createRestSource(Reader source, RestRemoteRetriever<C> restRemoteRetriever) {
        Map m = (Map)new Yaml().load(source);
        SchemaNamespace namespace = SchemaNamespace.of((String)m.get("name"));
        Supplier<Reader> schema = () -> new StringReader((String)m.get("schema"));
        Map<String, RestRemoteSchemaSource.RootField> rootFields = ((Map)((Object)m.getOrDefault("rootFields", Collections.emptyList()))).entrySet().stream().map(e -> {
            String fieldName = (String)e.getKey();
            Map params = (Map)e.getValue();
            Mapper mapping = Mappers.fromYamlMap((Map)BraidObjects.cast(params.get("responseMapping")));
            return new RestRemoteSchemaSource.RootField(fieldName, (String)params.get("uri"), mapping);
        }).collect(Collectors.toMap(f -> f.name, f -> f));
        return new RestRemoteSchemaSource<C>(namespace, schema, restRemoteRetriever, rootFields, YamlRemoteSchemaSourceFactory.buildLinks(m), YamlRemoteSchemaSourceFactory.buildTopLevelFields(m));
    }

    public static <C extends BraidContext> SchemaSource<C> createGraphQLSource(Reader source, GraphQLRemoteRetriever<C> graphQLRemoteRetriever) {
        Map m = (Map)new Yaml().load(source);
        SchemaNamespace namespace = SchemaNamespace.of((String)m.get("name"));
        Supplier<Reader> schema = () -> new StringReader((String)m.get("schema"));
        return new GraphQLRemoteSchemaSource<C>(namespace, schema, graphQLRemoteRetriever, YamlRemoteSchemaSourceFactory.buildLinks(m), YamlRemoteSchemaSourceFactory.buildTopLevelFields(m));
    }

    private static String[] buildTopLevelFields(Map<String, Object> m) {
        return Optional.ofNullable((List)m.get("topLevelFields")).orElse(Collections.emptyList()).toArray(new String[0]);
    }

    private static List<Link> buildLinks(Map<String, Object> m) {
        return Optional.ofNullable((List)m.get("links")).map(links -> links.stream().map(l -> {
            Link.LinkBuilder link = Link.from(SchemaNamespace.of((String)m.get("name")), (String)((Map)l.get("from")).get("type"), (String)((Map)l.get("from")).get("field"), (String)((Map)l.get("from")).getOrDefault("fromField", ((Map)l.get("from")).get("field"))).to(SchemaNamespace.of((String)((Map)l.get("to")).get("namespace")), (String)((Map)l.get("to")).get("type"), (String)((Map)l.get("to")).get("field"));
            if (YamlRemoteSchemaSourceFactory.getReplaceFromField(l)) {
                link.replaceFromField();
            }
            Optional.ofNullable(((Map)l.get("to")).get("argument")).ifPresent(link::argument);
            String nullable = String.valueOf(((Map)l.get("to")).get("nullable"));
            Optional.ofNullable(nullable).map(String::valueOf).map(Boolean::valueOf).ifPresent(link::setNullable);
            return link.build();
        }).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static boolean getReplaceFromField(Map<String, Map<String, String>> l) {
        String argh = l.get("from").get("replaceFromField");
        boolean replaceFromField = false;
        if (argh != null) {
            replaceFromField = (Boolean)((Object)argh);
        }
        return replaceFromField;
    }
}

