/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.BraidContext;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.source.ForwardingSchemaSource;
import com.atlassian.braid.source.GraphQLRemoteRetriever;
import com.atlassian.braid.source.MapGraphQLError;
import com.atlassian.braid.source.OptionalHelper;
import com.atlassian.braid.source.QueryExecutorSchemaSource;
import com.atlassian.braid.source.SchemaUtils;
import graphql.ExecutionInput;
import graphql.execution.DataFetcherResult;
import java.io.Reader;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class GraphQLRemoteSchemaSource<C extends BraidContext>
extends ForwardingSchemaSource<C> {
    private final QueryExecutorSchemaSource<C> delegate;
    private final GraphQLRemoteRetriever<C> graphQLRemoteRetriever;

    public GraphQLRemoteSchemaSource(SchemaNamespace namespace, Supplier<Reader> schemaProvider, GraphQLRemoteRetriever<C> graphQLRemoteRetriever, List<Link> links, String ... topLevelFields) {
        this.graphQLRemoteRetriever = Objects.requireNonNull(graphQLRemoteRetriever);
        this.delegate = new QueryExecutorSchemaSource<BraidContext>(namespace, SchemaUtils.loadPublicSchema(schemaProvider, topLevelFields), SchemaUtils.loadSchema(schemaProvider), links, this::query);
    }

    @Override
    protected SchemaSource<C> getDelegate() {
        return this.delegate;
    }

    CompletableFuture<DataFetcherResult<Map<String, Object>>> query(ExecutionInput query, C context) {
        return this.graphQLRemoteRetriever.queryGraphQL(query, context).thenApply(response -> {
            Map data = OptionalHelper.castNullableMap(response.get("data"), String.class, Object.class).orElse(Collections.emptyMap());
            List errorsMap = OptionalHelper.castNullableList(response.get("errors"), Map.class).orElse(Collections.emptyList());
            List errors = errorsMap.stream().map(val -> new MapGraphQLError(OptionalHelper.castNullableMap(val, String.class, Object.class).orElseThrow(IllegalArgumentException::new))).collect(Collectors.toList());
            return new DataFetcherResult(data, errors);
        });
    }
}

