/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.java.util.BraidMaps;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.mapper.Mapper;
import com.atlassian.braid.mapper.MapperOperation;
import com.atlassian.braid.mapper.SpringExpressions;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;

final class CopyOperation<T, R>
implements MapperOperation {
    private static BiFunction<Map<String, Object>, String, Optional<Object>> getFromMap;
    private final String sourceKey;
    private final String targetKey;
    private final Supplier<R> defaultValue;
    private final Function<T, R> transform;

    CopyOperation(String sourceKey, String targetKey, Supplier<R> defaultValue, Function<T, R> transform) {
        this.sourceKey = Objects.requireNonNull(sourceKey);
        this.targetKey = Objects.requireNonNull(targetKey);
        this.defaultValue = Objects.requireNonNull(defaultValue);
        this.transform = Objects.requireNonNull(transform);
    }

    @Override
    public void accept(Map<String, Object> input, Map<String, Object> output) {
        R value = getFromMap.apply(input, this.sourceKey).map(BraidObjects::cast).map(this.transform).orElseGet(this.defaultValue);
        if (value != null) {
            output.put(this.targetKey, value);
        }
    }

    private static <T> T newInstance(String name) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return BraidObjects.cast(Mapper.class.getClassLoader().loadClass(name).newInstance());
    }

    static {
        try {
            getFromMap = ((SpringExpressions)CopyOperation.newInstance("com.atlassian.braid.mapper.SpringExpressions"))::get;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LoggerFactory.getLogger(CopyOperation.class).debug("Spring not found, using simple property expressions", (Throwable)e);
            getFromMap = BraidMaps::get;
        }
    }
}

