/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.SchemaNamespace;
import java.util.Objects;
import java.util.Optional;

public final class Link {
    private final LinkSource source;
    private final LinkTarget target;
    private final LinkArgument argument;
    private final boolean nullable;

    private Link(LinkSource source, LinkTarget target, LinkArgument argument, boolean nullable) {
        this.source = Objects.requireNonNull(source);
        this.target = Objects.requireNonNull(target);
        this.argument = Objects.requireNonNull(argument);
        this.nullable = nullable;
    }

    public static LinkBuilder from(SchemaNamespace namespace, String type, String field) {
        return Link.from(namespace, type, field, field);
    }

    public static LinkBuilder from(SchemaNamespace namespace, String type, String field, String fromField) {
        return new LinkBuilder(new LinkSource(namespace, type, field, fromField));
    }

    public String getSourceType() {
        return this.source.type;
    }

    public String getSourceField() {
        return this.source.field;
    }

    public String getSourceFromField() {
        return this.source.fromField;
    }

    public SchemaNamespace getTargetNamespace() {
        return this.target.namespace;
    }

    public String getTargetType() {
        return this.target.type;
    }

    public String getTargetField() {
        return Optional.ofNullable(this.target.queryField).orElse(this.source.field);
    }

    public String getArgumentName() {
        return this.argument.name;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.source, link.source) && Objects.equals(this.target, link.target) && Objects.equals(this.argument, link.argument);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.target, this.argument);
    }

    public String toString() {
        return "Link{source=" + this.source + ", target=" + this.target + ", argument=" + this.argument + '}';
    }

    private static class LinkArgument {
        private final String name;

        private LinkArgument(String name) {
            this.name = Objects.requireNonNull(name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LinkArgument that = (LinkArgument)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }

        public String toString() {
            return "LinkArgument{name='" + this.name + '\'' + '}';
        }
    }

    private static class LinkTarget {
        private final SchemaNamespace namespace;
        private final String type;
        private final String queryField;

        private LinkTarget(SchemaNamespace namespace, String type, String queryField) {
            this.namespace = Objects.requireNonNull(namespace);
            this.type = Objects.requireNonNull(type);
            this.queryField = queryField;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LinkTarget that = (LinkTarget)o;
            return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.type, that.type) && Objects.equals(this.queryField, that.queryField);
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.type, this.queryField);
        }

        public String toString() {
            return "LinkTarget{namespace=" + this.namespace + ", type='" + this.type + '\'' + ", queryField='" + this.queryField + '\'' + '}';
        }
    }

    private static class LinkSource {
        private final SchemaNamespace namespace;
        private final String type;
        private final String field;
        private final String fromField;

        private LinkSource(SchemaNamespace namespace, String type, String field, String fromField) {
            this.namespace = Objects.requireNonNull(namespace);
            this.type = Objects.requireNonNull(type);
            this.field = Objects.requireNonNull(field);
            this.fromField = Objects.requireNonNull(fromField);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LinkSource that = (LinkSource)o;
            return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.type, that.type) && Objects.equals(this.field, that.field) && Objects.equals(this.fromField, that.fromField);
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.type, this.field, this.fromField);
        }

        public String toString() {
            return "LinkSource{namespace=" + this.namespace + ", type='" + this.type + '\'' + ", field='" + this.field + '\'' + ", fromField='" + this.fromField + '\'' + '}';
        }
    }

    public static final class LinkBuilder {
        private LinkSource source;
        private LinkTarget target;
        private LinkArgument argument = new LinkArgument("id");
        private boolean nullable = false;

        LinkBuilder(LinkSource source) {
            this.source = Objects.requireNonNull(source);
        }

        public LinkBuilder to(SchemaNamespace namespace, String type) {
            return this.to(namespace, type, null);
        }

        public LinkBuilder to(SchemaNamespace namespace, String type, String queryField) {
            this.target = new LinkTarget(namespace, type, queryField);
            return this;
        }

        public LinkBuilder argument(String sourceName) {
            this.argument = new LinkArgument(sourceName);
            return this;
        }

        public Link build() {
            return new Link(this.source, this.target, this.argument, this.nullable);
        }

        public LinkBuilder setNullable(boolean nullable) {
            this.nullable = nullable;
            return this;
        }
    }
}

