/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.source.GraphQLRemoteRetriever;
import com.fasterxml.jackson.databind.ObjectMapper;
import graphql.ExecutionInput;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class HttpGraphQLRemoteRetriever<C>
implements GraphQLRemoteRetriever<C> {
    private final ObjectMapper mapper = new ObjectMapper();
    private final URL remoteUrl;

    public HttpGraphQLRemoteRetriever(URL remoteUrl) {
        this.remoteUrl = Objects.requireNonNull(remoteUrl);
    }

    @Override
    public CompletableFuture<Map<String, Object>> queryGraphQL(ExecutionInput executionInput, C context) {
        return CompletableFuture.completedFuture(this.queryForJson(out -> {
            try {
                this.mapper.writeValue(out, (Object)executionInput);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> queryForJson(Consumer<OutputStream> bodyWriter) {
        URLConnection urlConnection = this.remoteUrl.openConnection();
        if (!(urlConnection instanceof HttpURLConnection)) {
            throw new RuntimeException("Expected an HTTP endpoint");
        }
        HttpURLConnection connection = (HttpURLConnection)urlConnection;
        try {
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("content-type", "application/json");
            bodyWriter.accept(connection.getOutputStream());
            if (connection.getResponseCode() != 200) {
                throw new IOException("Failed with HTTP error code: " + connection.getResponseCode());
            }
            Map map = (Map)this.mapper.readerFor(Map.class).readValue(connection.getInputStream());
            connection.disconnect();
            return map;
        }
        catch (Throwable throwable) {
            try {
                connection.disconnect();
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

