/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.Link;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;

public class BatchLoaderUtils {
    public static String getTargetIdFromEnvironment(Link link, DataFetchingEnvironment environment) {
        Map<String, String> source = BatchLoaderUtils.waitForMapSource(environment);
        return source.get(link.getSourceFromField());
    }

    private static Map<String, String> waitForMapSource(DataFetchingEnvironment environment) {
        Object source = environment.getSource();
        while (!(source instanceof Map)) {
            if (source instanceof CompletableFuture) {
                try {
                    source = ((CompletableFuture)source).get();
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            if (source instanceof DataFetcherResult) {
                source = ((DataFetcherResult)source).getData();
                continue;
            }
            throw new IllegalArgumentException("Unexpected parent type");
        }
        return (Map)source;
    }
}

