/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.mapper.FieldOperation;
import com.atlassian.braid.mapper.Mapper;
import com.atlassian.braid.mapper.operation.CopyFieldOperation;
import com.atlassian.braid.mapper.operation.CopyListFieldOperation;
import com.atlassian.braid.mapper.operation.CopyMapFieldOperation;
import com.atlassian.braid.mapper.operation.MapFieldOperation;
import com.atlassian.braid.mapper.operation.PutFieldOperation;
import com.atlassian.braid.mapper.operation.SingletonListFieldOperation;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.Yaml;

public class YamlMapper {
    private static final Map<String, Function<FieldOperationSource, FieldOperation>> fieldOperations = new HashMap<String, Function<FieldOperationSource, FieldOperation>>(){
        {
            this.put("copy", src -> new CopyFieldOperation(src.getName(), src.getProperties(), src.getOps()));
            this.put("copyList", src -> new CopyListFieldOperation(src.getName(), src.getProperties(), src.getOps()));
            this.put("singletonList", src -> new SingletonListFieldOperation(src.getName(), src.getOps()));
            this.put("put", src -> new PutFieldOperation(src.getName(), src.getProperties(), src.getOps()));
            this.put("map", src -> new MapFieldOperation(src.getName(), src.getOps()));
            this.put("copyMap", src -> new CopyMapFieldOperation(src.getName(), src.getProperties(), src.getOps()));
        }
    };
    private final List<FieldOperation> operations;

    public YamlMapper(Reader yaml) {
        this((Map)new Yaml().load(yaml));
    }

    public YamlMapper(Map<String, Object> yaml) {
        this.operations = this.createFieldOperations(yaml);
    }

    public Map<String, Object> map(Map<String, Object> source) {
        Mapper mapper = Mapper.newMapper(source);
        this.process(mapper, this.operations);
        return mapper.build();
    }

    private void process(Mapper mapper, List<FieldOperation> operations) {
        for (FieldOperation op : operations) {
            op.execute(mapper);
        }
    }

    private List<FieldOperation> createFieldOperations(Map<String, Object> elements) {
        if (elements == null) {
            return Collections.emptyList();
        }
        return elements.entrySet().stream().map((? super T e) -> {
            String op;
            Map<String, Object> args;
            String fieldName = (String)e.getKey();
            if (e.getValue() instanceof Map) {
                args = (Map<String, Object>)e.getValue();
                op = (String)args.get("op");
            } else {
                op = (String)e.getValue();
                args = Collections.emptyMap();
            }
            List<FieldOperation> ops = this.createFieldOperations((Map)args.get("elements"));
            return Optional.ofNullable(fieldOperations.get(op)).orElseThrow(() -> new IllegalArgumentException(String.format("Invalid operation %s for field %s", op, fieldName))).apply(new FieldOperationSource(fieldName, args, ops));
        }).collect(Collectors.toList());
    }

    private static class FieldOperationSource {
        private final String name;
        private final Map<String, Object> properties;
        private final List<FieldOperation> ops;

        public FieldOperationSource(String name, Map<String, Object> properties, List<FieldOperation> ops) {
            this.name = name;
            this.properties = properties;
            this.ops = ops;
        }

        public String getName() {
            return this.name;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public List<FieldOperation> getOps() {
            return this.ops;
        }
    }
}

