/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.mapper;

import com.atlassian.braid.mapper.ExpressionEvaluator;
import com.atlassian.braid.mapper.Mapper;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

class DefaultMapper
implements Mapper {
    private static final Consumer<Object> NOOP = __ -> {};
    private final Mapper parent;
    private final Consumer<Object> doneAction;
    private final Map<String, Object> source;
    private final Map<String, Object> target;
    private final ExpressionEvaluator expressionEvaluator;

    DefaultMapper(ExpressionEvaluator expressionEvaluator, Map<String, Object> source) {
        this(expressionEvaluator, null, source, null);
    }

    private DefaultMapper(ExpressionEvaluator expressionEvaluator, Mapper parent, Map<String, Object> source, Consumer<Object> doneAction) {
        this.expressionEvaluator = expressionEvaluator;
        this.source = source;
        this.target = new HashMap<String, Object>();
        this.parent = parent;
        this.doneAction = doneAction;
    }

    @Override
    public Mapper copy(String key) {
        return this.copy(key, Function.identity());
    }

    @Override
    public <T, R> Mapper copy(String key, Function<T, R> transform) {
        return this.copy(key, key, transform);
    }

    @Override
    public <T> Mapper copy(String key, Supplier<T> defaultValue) {
        return this.copy(key, key, defaultValue);
    }

    @Override
    public <T, R> Mapper copy(String key, Function<T, R> transform, Supplier<R> defaultValue) {
        return this.copy(key, key, transform, defaultValue);
    }

    @Override
    public Mapper copy(String sourcePath, String targetKey) {
        return this.copy(sourcePath, targetKey, Function.identity());
    }

    @Override
    public <T> Mapper copy(String sourcePath, String targetKey, Supplier<T> defaultValue) {
        return this.copy(sourcePath, targetKey, Function.identity(), defaultValue);
    }

    @Override
    public <T, R> Mapper copy(String sourcePath, String targetKey, Function<T, R> transform) {
        return this.copy(sourcePath, targetKey, transform, () -> null);
    }

    @Override
    public <T, R> Mapper copy(String sourcePath, String targetKey, Function<T, R> transform, Supplier<R> defaultValue) {
        R value = this.getValue(sourcePath).map(transform).orElseGet(defaultValue);
        return this.doPut(targetKey, value);
    }

    @Override
    public Mapper map(String key) {
        return new DefaultMapper(this.expressionEvaluator, this, this.source, obj -> this.doPut(key, obj));
    }

    @Override
    public Mapper singletonList(String key) {
        return new DefaultMapper(this.expressionEvaluator, this, this.source, obj -> this.doPut(key, Collections.singletonList(obj)));
    }

    @Override
    public Mapper put(String key, Object value) {
        return this.doPut(key, value);
    }

    @Override
    public Mapper copyMap(String key) {
        return this.copyMap(key, key);
    }

    @Override
    public Mapper copyMap(String sourcePath, String targetKey) {
        return this.getValue(sourcePath).map((? super T value) -> new DefaultMapper(this.expressionEvaluator, this, (Map<String, Object>)value, obj -> this.doPut(targetKey, obj))).orElseGet(() -> new DefaultMapper(this.expressionEvaluator, this, Collections.emptyMap(), NOOP));
    }

    @Override
    public Mapper copyList(String sourcePath, String targetKey) {
        return this.getValue(sourcePath).map((? super T value) -> this.newListMapper(this, (List<Map<String, Object>>)value, obj -> this.doPut(targetKey, obj))).orElseGet(() -> new DefaultMapper(this.expressionEvaluator, this, Collections.emptyMap(), NOOP));
    }

    private Mapper doPut(String key, Object value) {
        if (value != null) {
            this.target.put(key, value);
        }
        return this;
    }

    private <T> Optional<T> getValue(String sourcePath) {
        return this.expressionEvaluator.getValue(this.source, sourcePath);
    }

    @Override
    public Mapper copyList(String key) {
        return this.copyList(key, key);
    }

    @Override
    public Mapper done() {
        this.doneAction.accept(this.target);
        return this.parent;
    }

    @Override
    public Map<String, Object> build() {
        if (this.doneAction != null) {
            this.doneAction.accept(this.target);
        }
        return this.target;
    }

    private Mapper newListMapper(Mapper parent, List<Map<String, Object>> source, Consumer<Object> doneAction) {
        List<Mapper> mappers = source.stream().map((? super T s) -> new DefaultMapper(this.expressionEvaluator, null, (Map<String, Object>)s, NOOP)).collect(Collectors.toList());
        return this.newMapperToListOfMappers(parent, doneAction, mappers);
    }

    private Mapper newMapperToListOfMappers(Mapper parent, Consumer<Object> doneAction, List<Mapper> mappers) {
        return (Mapper)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Mapper.class}, (proxy, method, args) -> {
            if (Arrays.asList("copyList", "map", "singletonList", "copyMap").contains(method.getName())) {
                ArrayList<Mapper> children = new ArrayList<Mapper>();
                for (Mapper m : mappers) {
                    children.add((Mapper)method.invoke((Object)m, args));
                }
                return this.newMapperToListOfMappers((Mapper)proxy, blah -> {}, children);
            }
            if ("done".equals(method.getName())) {
                doneAction.accept(mappers.stream().map(Mapper::build).collect(Collectors.toList()));
                return parent;
            }
            if ("build".equals(method.getName())) {
                doneAction.accept(mappers.stream().map(Mapper::build).collect(Collectors.toList()));
                return null;
            }
            for (Mapper m : mappers) {
                method.invoke((Object)m, args);
            }
            return proxy;
        });
    }
}

