/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import graphql.ExecutionInput;
import graphql.execution.DataFetcherResult;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class LocalSchemaSource<C>
implements SchemaSource<C> {
    private final SchemaNamespace namespace;
    private final TypeDefinitionRegistry schema;
    private final List<Link> links;
    private final Function<ExecutionInput, Object> queryExecutor;

    public LocalSchemaSource(SchemaNamespace namespace, TypeDefinitionRegistry schema, Function<ExecutionInput, Object> queryExecutor) {
        this(namespace, schema, Collections.emptyList(), queryExecutor);
    }

    public LocalSchemaSource(SchemaNamespace namespace, TypeDefinitionRegistry schema, List<Link> links, Function<ExecutionInput, Object> queryExecutor) {
        this.namespace = Objects.requireNonNull(namespace);
        this.schema = Objects.requireNonNull(schema);
        this.links = Objects.requireNonNull(links);
        this.queryExecutor = Objects.requireNonNull(queryExecutor);
    }

    @Override
    public TypeDefinitionRegistry getSchema() {
        return this.schema;
    }

    @Override
    public SchemaNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public List<Link> getLinks() {
        return this.links;
    }

    @Override
    public CompletableFuture<DataFetcherResult<Map<String, Object>>> query(ExecutionInput query, C context) {
        Object result = this.queryExecutor.apply(query);
        if (result instanceof DataFetcherResult) {
            return CompletableFuture.completedFuture((DataFetcherResult)result);
        }
        if (result instanceof Map) {
            return CompletableFuture.completedFuture(new DataFetcherResult((Object)((Map)result), Collections.emptyList()));
        }
        CompletableFuture<DataFetcherResult<Map<String, Object>>> future = new CompletableFuture<DataFetcherResult<Map<String, Object>>>();
        future.completeExceptionally(new IllegalArgumentException());
        return future;
    }
}

