/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import java.util.Objects;

public class Link {
    private final String sourceType;
    private final String sourceField;
    private String targetNamespace;
    private String targetType;
    private String argumentName = "id";
    private String targetField;

    private Link(String sourceType, String sourceField) {
        this.sourceType = Objects.requireNonNull(sourceType);
        this.sourceField = Objects.requireNonNull(sourceField);
        this.targetField = sourceField;
    }

    public static Link from(String sourceType, String sourceField) {
        return new Link(sourceType, sourceField);
    }

    public Link to(String targetNamespace, String targetType) {
        this.targetNamespace = Objects.requireNonNull(targetNamespace);
        this.targetType = Objects.requireNonNull(targetType);
        return this;
    }

    public Link targetArgument(String argumentName) {
        this.argumentName = Objects.requireNonNull(argumentName);
        return this;
    }

    public Link targetField(String targetField) {
        this.targetField = Objects.requireNonNull(targetField);
        return this;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getSourceField() {
        return this.sourceField;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public String getArgumentName() {
        return this.argumentName;
    }

    public String getTargetField() {
        return this.targetField;
    }
}

