/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.Link;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.source.SchemaLoader;
import graphql.introspection.IntrospectionResultToSchema;
import graphql.language.Document;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public final class SchemaUtils {
    private static final Function<Reader, Map> readerToMap = SchemaUtils.createReaderToMapInstance();

    private SchemaUtils() {
    }

    public static TypeDefinitionRegistry loadPublicSchema(SchemaLoader schemaLoader, List<Link> links, String ... topLevelFields) {
        return TypeUtils.filterQueryType(schemaLoader.load(), links, topLevelFields);
    }

    public static TypeDefinitionRegistry loadSchema(SchemaLoader.Type type, Reader reader) {
        switch (type) {
            case IDL: {
                return SchemaUtils.loadSchemaFromIdl(reader);
            }
            case INTROSPECTION: {
                return SchemaUtils.loadSchemaFromIntrospection(reader);
            }
        }
        throw new IllegalArgumentException("Type not supported: " + (Object)((Object)type));
    }

    private static TypeDefinitionRegistry loadSchemaFromIdl(Reader schemaReader) {
        SchemaParser parser = new SchemaParser();
        return parser.parse(schemaReader);
    }

    private static TypeDefinitionRegistry loadSchemaFromIntrospection(Reader schemaReader) {
        SchemaParser parser = new SchemaParser();
        Map result = readerToMap.apply(schemaReader);
        Document schemaDoc = new IntrospectionResultToSchema().createSchemaDefinition(result);
        return parser.buildRegistry(schemaDoc);
    }

    private static Function<Reader, Map> createReaderToMapInstance() {
        try {
            Class<?> clazz = SchemaUtils.class.getClassLoader().loadClass("com.atlassian.braid.source.jackson.JacksonJsonToMapParser");
            return (Function)clazz.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            return reader -> {
                throw new RuntimeException("Jackson not found, so loading introspection docs not supported");
            };
        }
    }
}

