/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.Extension;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.graphql.language.KeyedDataFetchingEnvironment;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.transformation.BraidSchemaSource;
import com.atlassian.braid.transformation.BraidTypeDefinition;
import com.atlassian.braid.transformation.BraidingContext;
import com.atlassian.braid.transformation.ExtensionTransformation;
import com.atlassian.braid.transformation.SchemaTransformation;
import graphql.execution.DataFetcherResult;
import graphql.language.Field;
import graphql.language.FieldDefinition;
import graphql.language.ObjectTypeDefinition;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentBuilder;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.dataloader.BatchLoader;

public class ExtensionSchemaTransformation
implements SchemaTransformation {
    @Override
    public Map<String, BatchLoader> transform(BraidingContext ctx) {
        return ctx.getRegistry().types().values().stream().flatMap(typeDef -> BraidTypeDefinition.getFieldDefinitions(typeDef).stream().flatMap(fieldDef -> ctx.getDataSources().values().stream().filter(ds -> ds.hasTypeAndField(ctx.getRegistry(), (TypeDefinition)typeDef, (FieldDefinition)fieldDef)).flatMap(ds -> ds.getExtensions(ds.getSourceTypeName(TypeUtils.unwrap(fieldDef.getType()))).stream().map(ext -> this.mergeType((BraidSchemaSource)ds, ctx, (TypeDefinition)typeDef, (FieldDefinition)fieldDef, (Extension)ext)).flatMap(m -> m.entrySet().stream())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>>> mergeType(BraidSchemaSource ds, BraidingContext ctx, TypeDefinition typeDef, FieldDefinition fieldDef, Extension ext) {
        ObjectTypeDefinition originalType = this.findRequiredOriginalType(ctx, ds, fieldDef);
        Set<String> originalTypeFieldNames = originalType.getFieldDefinitions().stream().map(FieldDefinition::getName).collect(Collectors.toSet());
        BraidSchemaSource targetSource = ctx.getDataSources().get(ext.getBy().getNamespace());
        ObjectTypeDefinition targetType = this.findRequiredTargetType(targetSource, ext);
        String key = "ext-" + typeDef.getName();
        this.wireNewFields(ctx, ds, typeDef, fieldDef, ext, originalType, originalTypeFieldNames, targetType, key);
        SchemaSource schemaSource = ctx.getDataSources().get(ext.getBy().getNamespace()).getSchemaSource();
        return Collections.singletonMap(key, schemaSource.newBatchLoader(schemaSource, new ExtensionTransformation(ext), ctx.getBatchLoaderEnvironment()));
    }

    private ObjectTypeDefinition findRequiredTargetType(BraidSchemaSource targetSource, Extension ext) {
        return (ObjectTypeDefinition)targetSource.getType(ext.getBy().getType()).orElseThrow(IllegalAccessError::new);
    }

    private ObjectTypeDefinition findRequiredOriginalType(BraidingContext ctx, BraidSchemaSource braidSchemaSource, FieldDefinition fieldDef) {
        return (ObjectTypeDefinition)ctx.getRegistry().getType(braidSchemaSource.getBraidTypeName(TypeUtils.unwrap(fieldDef.getType()))).orElseThrow(IllegalArgumentException::new);
    }

    private void wireNewFields(BraidingContext ctx, BraidSchemaSource ds, TypeDefinition typeDef, FieldDefinition fieldDef, Extension ext, ObjectTypeDefinition originalType, Set<String> originalTypeFieldNames, ObjectTypeDefinition targetType, String key) {
        targetType.getFieldDefinitions().stream().filter(fd -> !originalTypeFieldNames.contains(fd.getName())).forEach(fd -> {
            originalType.getFieldDefinitions().add(fd);
            ctx.registerDataFetcher(ds.getBraidTypeName(ext.getType()), fd.getName(), this.buildDataFetcher(ds, typeDef, fieldDef, key, (FieldDefinition)fd));
        });
    }

    private DataFetcher buildDataFetcher(BraidSchemaSource ds, TypeDefinition typeDef, FieldDefinition fieldDef, String key, FieldDefinition fd) {
        return env -> ((CompletableFuture)env.getDataLoader(key).load((Object)new KeyedDataFetchingEnvironment(ExtensionSchemaTransformation.updateDataFetchingEnvironment(ds, typeDef, fieldDef, env))).thenApply(BraidObjects::cast)).thenApply(dfr -> ExtensionSchemaTransformation.nullSafeGetFieldValue((DataFetcherResult<Map<String, Object>>)dfr, fd.getName()));
    }

    private static Object nullSafeGetFieldValue(@Nullable DataFetcherResult<Map<String, Object>> dfr, String fieldName) {
        return Optional.ofNullable(dfr).flatMap(r -> Optional.ofNullable(r.getData())).map(data -> data.get(fieldName)).orElse(null);
    }

    private static DataFetchingEnvironment updateDataFetchingEnvironment(BraidSchemaSource ds, TypeDefinition typeDef, FieldDefinition fieldDef, DataFetchingEnvironment env) {
        GraphQLSchema graphQLSchema = env.getGraphQLSchema();
        return DataFetchingEnvironmentBuilder.newDataFetchingEnvironment((DataFetchingEnvironment)env).source(env.getSource()).fieldDefinition(graphQLSchema.getObjectType(ds.getBraidTypeName(typeDef.getName())).getFieldDefinition(fieldDef.getName())).fields(Collections.singletonList(new Field(fieldDef.getName()))).fieldType((GraphQLOutputType)graphQLSchema.getObjectType(((TypeName)fieldDef.getType()).getName())).parentType((GraphQLType)graphQLSchema.getObjectType("Query")).build();
    }
}

