/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.BatchLoaderEnvironment;
import com.atlassian.braid.Link;
import com.atlassian.braid.LinkArgument;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.TypeUtils;
import com.atlassian.braid.transformation.BraidSchemaSource;
import com.atlassian.braid.transformation.BraidingContext;
import com.atlassian.braid.transformation.DataFetcherUtils;
import com.atlassian.braid.transformation.LinkTransformation;
import com.atlassian.braid.transformation.SchemaTransformation;
import graphql.execution.DataFetcherResult;
import graphql.language.FieldDefinition;
import graphql.language.InputValueDefinition;
import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.Type;
import graphql.language.TypeDefinition;
import graphql.language.TypeName;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dataloader.BatchLoader;

public class LinkSchemaTransformation
implements SchemaTransformation {
    @Override
    public Map<String, BatchLoader> transform(BraidingContext braidingContext) {
        return LinkSchemaTransformation.linkTypes(braidingContext.getDataSources(), braidingContext.getQueryObjectTypeDefinition(), braidingContext.getMutationObjectTypeDefinition(), braidingContext.getRuntimeWiringBuilder(), braidingContext.getBatchLoaderEnvironment(), braidingContext.getRegistry());
    }

    private static Map<String, BatchLoader> linkTypes(Map<SchemaNamespace, BraidSchemaSource> sources, ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition, RuntimeWiring.Builder runtimeWiringBuilder, BatchLoaderEnvironment batchLoaderEnvironment, TypeDefinitionRegistry braidTypeRegistry) {
        HashMap<String, BatchLoader> batchLoaders = new HashMap<String, BatchLoader>();
        for (BraidSchemaSource source : sources.values()) {
            TypeDefinitionRegistry typeRegistry = source.getTypeRegistry();
            TypeDefinitionRegistry privateTypes = source.getSchemaSource().getPrivateSchema();
            HashMap<String, TypeDefinition> dsTypes = new HashMap<String, TypeDefinition>(braidTypeRegistry.types());
            for (Link link : source.getSchemaSource().getLinks()) {
                ObjectTypeDefinition braidObjectTypeDefinition = LinkSchemaTransformation.getObjectTypeDefinition(queryObjectTypeDefinition, mutationObjectTypeDefinition, braidTypeRegistry, dsTypes, source.getLinkBraidSourceType(link));
                if (braidObjectTypeDefinition.equals(TypeUtils.findQueryType(braidTypeRegistry).orElse(null))) {
                    braidObjectTypeDefinition = TypeUtils.findQueryType(typeRegistry).get();
                }
                if (braidObjectTypeDefinition.equals(TypeUtils.findMutationType(braidTypeRegistry).orElse(null))) {
                    braidObjectTypeDefinition = TypeUtils.findMutationType(typeRegistry).get();
                }
                LinkSchemaTransformation.validateSourceFromFieldExists(source, link, privateTypes);
                Optional<FieldDefinition> newField = braidObjectTypeDefinition.getFieldDefinitions().stream().filter(d -> d.getName().equals(link.getNewFieldName())).findFirst();
                BraidSchemaSource targetSource = sources.get(link.getTargetNamespace());
                if (targetSource == null) {
                    throw new IllegalArgumentException("Can't find target schema source: " + link.getTargetNamespace());
                }
                if (!targetSource.hasType(link.getTargetType())) {
                    throw new IllegalArgumentException("Can't find target type: " + link.getTargetType());
                }
                FieldDefinition topLevelField = LinkSchemaTransformation.topLevelFieldForLink(link, targetSource);
                if (!link.isNoSchemaChangeNeeded()) {
                    LinkSchemaTransformation.modifySchema(link, braidObjectTypeDefinition, newField, topLevelField);
                }
                String type = source.getLinkBraidSourceType(link);
                String field = link.getNewFieldName();
                String linkDataLoaderKey = DataFetcherUtils.getLinkDataLoaderKey(type, field);
                DataFetcher dataFetcher = env -> env.getDataLoader(linkDataLoaderKey).load((Object)env);
                runtimeWiringBuilder.type(type, wiring -> wiring.dataFetcher(field, dataFetcher));
                BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> batchLoader = targetSource.getSchemaSource().newBatchLoader(targetSource.getSchemaSource(), new LinkTransformation(link), batchLoaderEnvironment);
                batchLoaders.put(linkDataLoaderKey, batchLoader);
            }
        }
        return batchLoaders;
    }

    private static FieldDefinition topLevelFieldForLink(Link link, BraidSchemaSource targetSource) {
        return (FieldDefinition)TypeUtils.findQueryType(targetSource.getSchemaSource().getPrivateSchema()).flatMap(queryType -> queryType.getFieldDefinitions().stream().filter(fieldDefinitiuon -> link.getTopLevelQueryField().equals(fieldDefinitiuon.getName())).findFirst()).orElseThrow(() -> new IllegalStateException(String.format("Cannot find top level query field '%s' in source '%s' for link on field '%s' defined in '%s'", link.getTopLevelQueryField(), link.getTargetNamespace(), link.getNewFieldName(), link.getSourceNamespace())));
    }

    private static void modifySchema(Link link, ObjectTypeDefinition typeDefinition, Optional<FieldDefinition> newField, FieldDefinition topLevelField) {
        Map<String, FieldDefinition> objectFields = typeDefinition.getFieldDefinitions().stream().filter(Objects::nonNull).collect(Collectors.toMap(FieldDefinition::getName, Function.identity()));
        link.getLinkArguments().stream().filter(linkArgument -> linkArgument.getArgumentSource() == LinkArgument.ArgumentSource.OBJECT_FIELD && linkArgument.isRemoveInputField()).map(LinkArgument::getSourceName).forEach(fieldToRemove -> Optional.ofNullable(objectFields.get(fieldToRemove)).ifPresent(fieldDef -> typeDefinition.getFieldDefinitions().remove(fieldDef)));
        TypeName targetType = new TypeName(link.getTargetType());
        Object object = targetType = link.targetNonNullable() ? NonNullType.newNonNullType((Type)targetType).build() : targetType;
        if (!newField.isPresent()) {
            targetType = LinkSchemaTransformation.adjustTypeForSimpleLink(link, objectFields, (Type)targetType);
            FieldDefinition field = new FieldDefinition(link.getNewFieldName(), (Type)targetType);
            List inputValueDefs = link.getLinkArguments().stream().filter(linkArgument -> linkArgument.getArgumentSource() == LinkArgument.ArgumentSource.FIELD_ARGUMENT).flatMap(linkArgument -> LinkSchemaTransformation.buildInputValueDefinitionForLink(topLevelField, linkArgument)).collect(Collectors.toList());
            field.getInputValueDefinitions().addAll(inputValueDefs);
            typeDefinition.getFieldDefinitions().add(field);
        } else if (LinkSchemaTransformation.isListType(newField.get().getType())) {
            if (newField.get().getType() instanceof NonNullType) {
                newField.get().setType((Type)new NonNullType((Type)new ListType((Type)targetType)));
            } else {
                newField.get().setType((Type)new ListType((Type)targetType));
            }
        } else {
            newField.get().setType((Type)targetType);
        }
    }

    private static Stream<InputValueDefinition> buildInputValueDefinitionForLink(FieldDefinition topLevelField, LinkArgument linkArgument) {
        return topLevelField.getInputValueDefinitions().stream().filter(input -> linkArgument.getQueryArgumentName().equals(input.getName())).findFirst().map(input -> Stream.of(InputValueDefinition.newInputValueDefinition().name(linkArgument.getSourceName()).type(input.getType()).build())).orElse(Stream.empty());
    }

    private static Type adjustTypeForSimpleLink(Link link, Map<String, FieldDefinition> objectFields, Type targetType) {
        Optional<FieldDefinition> sourceInputField;
        if (link.isSimpleLink() && (sourceInputField = Optional.ofNullable(objectFields.get(link.getSourceInputFieldName()))).isPresent() && LinkSchemaTransformation.isListType(sourceInputField.get().getType())) {
            targetType = new ListType(targetType);
        }
        return targetType;
    }

    private static ObjectTypeDefinition getObjectTypeDefinition(ObjectTypeDefinition queryObjectTypeDefinition, ObjectTypeDefinition mutationObjectTypeDefinition, TypeDefinitionRegistry typeRegistry, Map<String, TypeDefinition> dsTypes, String linkSourceType) {
        ObjectTypeDefinition typeDefinition = (ObjectTypeDefinition)dsTypes.get(linkSourceType);
        if (typeDefinition == null && linkSourceType.equals(queryObjectTypeDefinition.getName()) && (typeDefinition = (ObjectTypeDefinition)TypeUtils.findQueryType(typeRegistry).orElse(null)) == null && linkSourceType.equals(mutationObjectTypeDefinition.getName())) {
            typeDefinition = TypeUtils.findMutationType(typeRegistry).orElse(null);
        }
        if (typeDefinition == null) {
            throw new IllegalArgumentException("Can't find source type: " + linkSourceType);
        }
        return typeDefinition;
    }

    private static void validateSourceFromFieldExists(BraidSchemaSource source, Link link, TypeDefinitionRegistry privateTypeDefinitionRegistry) {
        String sourceType = source.getSourceTypeName(link.getSourceType());
        ObjectTypeDefinition typeDefinition = (ObjectTypeDefinition)privateTypeDefinitionRegistry.getType(sourceType, ObjectTypeDefinition.class).orElseThrow(() -> new IllegalArgumentException(String.format("Can't find source type '%s' in private schema for link %s", sourceType, link.getNewFieldName())));
        Map fieldsByName = typeDefinition.getFieldDefinitions().stream().collect(Collectors.toMap(FieldDefinition::getName, Function.identity()));
        List missingSourceObjectFields = link.getLinkArguments().stream().filter(linkArgument -> linkArgument.getArgumentSource() == LinkArgument.ArgumentSource.OBJECT_FIELD).filter(linkArgument -> !fieldsByName.containsKey(linkArgument.getSourceName())).map(LinkArgument::getSourceName).collect(Collectors.toList());
        if (!missingSourceObjectFields.isEmpty()) {
            String missingFieldsStr = missingSourceObjectFields.stream().collect(Collectors.joining(", "));
            throw new IllegalArgumentException("Can't find source from field: " + missingFieldsStr);
        }
    }

    private static boolean isListType(Type type) {
        return type instanceof ListType || type instanceof NonNullType && ((NonNullType)type).getType() instanceof ListType;
    }
}

