/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.switching;

import com.atlassian.braid.BatchLoaderEnvironment;
import com.atlassian.braid.BraidContexts;
import com.atlassian.braid.Extension;
import com.atlassian.braid.FieldTransformation;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.source.AbstractSchemaSource;
import com.atlassian.braid.source.SchemaLoader;
import com.atlassian.braid.source.SchemaUtils;
import com.atlassian.braid.switching.NamespaceSelector;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.dataloader.BatchLoader;
import sun.reflect.generics.reflectiveObjects.NotImplementedException;

public class SwitchingSchemaSource<C>
extends AbstractSchemaSource {
    private Map<String, SchemaSource> delegates;
    private NamespaceSelector<C> selector;

    public SwitchingSchemaSource(SchemaNamespace namespace, SchemaLoader schemaLoader, List<SchemaSource> delegates, NamespaceSelector<C> selector, List<Link> links, List<Extension> extensions, String ... topLevelFields) {
        super(namespace, SchemaUtils.loadPublicSchema(schemaLoader, links, topLevelFields), schemaLoader.load(), links, extensions);
        this.delegates = delegates.stream().collect(Collectors.toMap(schemaSource -> schemaSource.getNamespace().getValue(), schemaSource -> schemaSource));
        this.selector = selector;
    }

    @Override
    public BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> newBatchLoader(SchemaSource schemaSource, FieldTransformation fieldTransformation, BatchLoaderEnvironment batchLoaderEnvironment) {
        return envs -> {
            if (envs.isEmpty()) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            if (envs.size() > 1) {
                CompletableFuture failedFuture = new CompletableFuture();
                failedFuture.completeExceptionally(new NotImplementedException());
                return failedFuture;
            }
            DataFetchingEnvironment env = (DataFetchingEnvironment)envs.get(0);
            String namespace = this.selector.select(BraidContexts.get(env));
            SchemaSource selectedSchemaSource = this.delegates.get(namespace);
            BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> batchLoader = selectedSchemaSource.newBatchLoader(selectedSchemaSource, fieldTransformation, batchLoaderEnvironment);
            return batchLoader.load(Collections.singletonList(env));
        };
    }
}

