package com.atlassian.braid;

/**
 * <p>Defines the context of Braid GraphQL execution, from which the underlying context can be retrieved.
 * <p>Note: this class is for Braid's internal usage, and should not be used directly. Use methods on
 * {@link BraidContexts} to access context information
 *
 * @see BraidContexts
 *
 * @deprecated The underlying context object will no longer by wrapped in <code>BraidContext</code>. Its access will no
 * longer be interfered by Braid.
 */
public interface BraidContext<C> {

    /**
     * @return the underlying user set context
     */
    C getContext();
}
