/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.BatchLoaderEnvironment;
import com.atlassian.braid.Extension;
import com.atlassian.braid.FieldRename;
import com.atlassian.braid.FieldTransformation;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.TypeRename;
import com.atlassian.braid.document.DocumentMapper;
import com.atlassian.braid.document.DocumentMapperFactory;
import com.atlassian.braid.document.DocumentMappers;
import com.atlassian.braid.java.util.BraidObjects;
import com.atlassian.braid.source.AbstractSchemaSource;
import com.atlassian.braid.source.GraphQLRemoteRetriever;
import com.atlassian.braid.source.MapGraphQLError;
import com.atlassian.braid.source.Query;
import com.atlassian.braid.source.QueryExecutor;
import com.atlassian.braid.source.QueryFunction;
import com.atlassian.braid.source.ReaderSupplierSchemaLoader;
import com.atlassian.braid.source.SchemaLoader;
import com.atlassian.braid.source.SchemaUtils;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.dataloader.BatchLoader;

public class QueryExecutorSchemaSource<C>
extends AbstractSchemaSource
implements SchemaSource {
    private QueryExecutor<C> queryExecutor;
    private DocumentMapperFactory documentMapperFactory;
    private List<TypeRename> typeRenames;
    private List<FieldRename> queryFieldRenames;
    private List<FieldRename> mutationFieldRenames;

    private QueryExecutorSchemaSource(SchemaNamespace namespace, TypeDefinitionRegistry publicSchema, TypeDefinitionRegistry privateSchema, GraphQLRemoteRetriever<C> graphQLRemoteRetriever, Function<Query, Object> localExecutor, List<Link> links, List<Extension> extensions, DocumentMapperFactory documentMapperFactory, List<TypeRename> typeRenames, List<FieldRename> queryFieldRenames, List<FieldRename> mutationFieldRenames, String operationNamePrefix) {
        super(namespace, publicSchema, privateSchema, links, extensions, operationNamePrefix);
        this.documentMapperFactory = documentMapperFactory;
        this.typeRenames = typeRenames;
        this.queryFieldRenames = queryFieldRenames;
        this.mutationFieldRenames = mutationFieldRenames;
        if (graphQLRemoteRetriever != null) {
            this.queryExecutor = new QueryExecutor<C>(this.remoteQuery(graphQLRemoteRetriever));
        } else if (localExecutor != null) {
            this.queryExecutor = new QueryExecutor<C>(this.localQuery(localExecutor));
        }
    }

    @Override
    public BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> newBatchLoader(SchemaSource schemaSource, FieldTransformation fieldTransformation, BatchLoaderEnvironment batchLoaderEnvironment) {
        return this.queryExecutor.newBatchLoader(schemaSource, fieldTransformation, batchLoaderEnvironment);
    }

    private QueryFunction<C> localQuery(Function<Query, Object> queryExecutor) {
        return (query, context) -> {
            Object result = queryExecutor.apply(query);
            if (result instanceof DataFetcherResult) {
                return CompletableFuture.completedFuture((DataFetcherResult)BraidObjects.cast(result));
            }
            if (result instanceof Map) {
                return CompletableFuture.completedFuture(DataFetcherResult.newResult().data((Object)((Map)BraidObjects.cast(result))).build());
            }
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(new IllegalStateException("Unexpected result type: " + QueryExecutorSchemaSource.nullSafeGetClass(result)));
            return future;
        };
    }

    private static Class<?> nullSafeGetClass(Object result) {
        return Optional.ofNullable(result).map(Object::getClass).orElse(null);
    }

    public static <C> Builder<C> builder() {
        return new Builder();
    }

    private QueryFunction<C> remoteQuery(GraphQLRemoteRetriever<C> graphQLRemoteRetriever) {
        return (query, context) -> graphQLRemoteRetriever.queryGraphQL(query, context).thenApply(response -> {
            Map data = Optional.ofNullable(response.get("data")).map(BraidObjects::cast).orElse(Collections.emptyMap());
            List errorsMap = Optional.ofNullable(response.get("errors")).map(BraidObjects::cast).orElse(Collections.emptyList());
            List errors = errorsMap.stream().map(val -> Optional.ofNullable(val).map(BraidObjects::cast).orElseThrow(IllegalArgumentException::new)).map(MapGraphQLError::new).collect(Collectors.toList());
            return DataFetcherResult.newResult().data(data).errors(errors).build();
        });
    }

    public DocumentMapper<C> getDocumentMapper() {
        return (DocumentMapper)this.documentMapperFactory.apply(this.getSchema());
    }

    @Override
    public List<TypeRename> getTypeRenames() {
        return this.typeRenames;
    }

    @Override
    public List<FieldRename> getMutationFieldRenames() {
        return this.mutationFieldRenames;
    }

    @Override
    public List<FieldRename> getQueryFieldRenames() {
        return this.queryFieldRenames;
    }

    public static class Builder<C> {
        private List<Link> links = Collections.emptyList();
        private List<Extension> extensions = Collections.emptyList();
        private SchemaLoader schemaLoader;
        private SchemaNamespace schemaNamespace;
        private DocumentMapperFactory documentMapperFactory = DocumentMappers.identity();
        private GraphQLRemoteRetriever<C> remoteRetriever;
        private List<FieldRename> queryFieldRenames = Collections.emptyList();
        private List<FieldRename> mutationFieldRenames = Collections.emptyList();
        private List<TypeRename> typeRenames = Collections.emptyList();
        private Function<Query, Object> localRetriever;
        private String operationNamePrefix;

        private Builder() {
        }

        @Deprecated
        public Builder<C> schemaProvider(Supplier<Reader> schemaProvider) {
            this.schemaLoader = new ReaderSupplierSchemaLoader(SchemaLoader.Type.IDL, schemaProvider);
            return this;
        }

        public Builder<C> schemaLoader(SchemaLoader schemaLoader) {
            this.schemaLoader = schemaLoader;
            return this;
        }

        public Builder<C> queryFieldRenames(List<FieldRename> fieldRenames) {
            this.queryFieldRenames = fieldRenames;
            return this;
        }

        public Builder<C> mutationFieldRenames(List<FieldRename> fieldRenames) {
            this.mutationFieldRenames = fieldRenames;
            return this;
        }

        public Builder<C> topLevelFields(String ... topLevelFields) {
            return this.queryFieldRenames(Arrays.stream(topLevelFields).map(name -> FieldRename.from(name, name)).collect(Collectors.toList()));
        }

        public Builder<C> namespace(SchemaNamespace schemaNamespace) {
            this.schemaNamespace = schemaNamespace;
            return this;
        }

        public Builder<C> links(List<Link> links) {
            this.links = links;
            return this;
        }

        public Builder<C> extensions(List<Extension> extensions) {
            this.extensions = extensions;
            return this;
        }

        public Builder<C> documentMapperFactory(DocumentMapperFactory documentMapperFactory) {
            this.documentMapperFactory = documentMapperFactory;
            return this;
        }

        public Builder<C> remoteRetriever(GraphQLRemoteRetriever<C> remoteRetriever) {
            this.remoteRetriever = remoteRetriever;
            return this;
        }

        public Builder<C> localRetriever(Function<Query, Object> queryExecutor) {
            this.localRetriever = queryExecutor;
            return this;
        }

        public Builder<C> typeRenames(List<TypeRename> typeRenames) {
            this.typeRenames = typeRenames;
            return this;
        }

        public Builder<C> operationNamePrefix(String operationNamePrefix) {
            this.operationNamePrefix = operationNamePrefix;
            return this;
        }

        public QueryExecutorSchemaSource<C> build() {
            if (this.localRetriever != null && this.remoteRetriever != null) {
                throw new IllegalStateException("not allowed to have a localRetriever and a remoteRetriever");
            }
            if (this.localRetriever != null) {
                return new QueryExecutorSchemaSource(Objects.requireNonNull(this.schemaNamespace), SchemaUtils.loadPublicSchema(Objects.requireNonNull(this.schemaLoader), Objects.requireNonNull(this.links), (String[])this.queryFieldRenames.stream().map(FieldRename::getSourceName).toArray(String[]::new)), this.schemaLoader.load(), null, Objects.requireNonNull(this.localRetriever), Objects.requireNonNull(this.links), Objects.requireNonNull(this.extensions), Objects.requireNonNull(this.documentMapperFactory), Objects.requireNonNull(this.typeRenames), Objects.requireNonNull(this.queryFieldRenames), Objects.requireNonNull(this.mutationFieldRenames), this.operationNamePrefix);
            }
            return new QueryExecutorSchemaSource<C>(Objects.requireNonNull(this.schemaNamespace), SchemaUtils.loadPublicSchema(Objects.requireNonNull(this.schemaLoader), Objects.requireNonNull(this.links), (String[])this.queryFieldRenames.stream().map(FieldRename::getSourceName).toArray(String[]::new)), this.schemaLoader.load(), Objects.requireNonNull(this.remoteRetriever), null, Objects.requireNonNull(this.links), Objects.requireNonNull(this.extensions), Objects.requireNonNull(this.documentMapperFactory), Objects.requireNonNull(this.typeRenames), Objects.requireNonNull(this.queryFieldRenames), Objects.requireNonNull(this.mutationFieldRenames), this.operationNamePrefix);
        }
    }
}

