/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.document;

import com.atlassian.braid.document.SelectionOperation;
import com.atlassian.braid.mapper.MapperOperation;
import graphql.language.Definition;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;

abstract class RootDefinitionMappingResult<D extends Definition> {
    protected final D definition;
    protected final List<Selection> selections;
    protected final List<MapperOperation> mappers;

    private RootDefinitionMappingResult(D definition) {
        this(definition, new ArrayList<Selection>(), new ArrayList<MapperOperation>());
    }

    private RootDefinitionMappingResult(D definition, List<Selection> selections, List<MapperOperation> mappers) {
        this.definition = (Definition)Objects.requireNonNull(definition);
        this.selections = Objects.requireNonNull(selections);
        this.mappers = Objects.requireNonNull(mappers);
    }

    abstract D toDefinition();

    List<MapperOperation> getMapperOperations() {
        return Collections.unmodifiableList(this.mappers);
    }

    private void add(SelectionOperation.OperationResult result) {
        result.getSelection().ifPresent(this.selections::add);
        this.mappers.add(result.getMapper());
    }

    private static <D extends Definition> RootDefinitionMappingResult<D> combine(Function<D, RootDefinitionMappingResult<D>> constructor, RootDefinitionMappingResult<D> omr1, RootDefinitionMappingResult<D> omr2) {
        if (!Objects.equals(omr1.definition, omr2.definition)) {
            throw new IllegalArgumentException();
        }
        RootDefinitionMappingResult<D> result = constructor.apply(omr1.definition);
        result.selections.addAll(omr1.selections);
        result.selections.addAll(omr2.selections);
        result.mappers.addAll(omr1.mappers);
        result.mappers.addAll(omr2.mappers);
        return result;
    }

    static Collector<SelectionOperation.OperationResult, RootDefinitionMappingResult<OperationDefinition>, RootDefinitionMappingResult<OperationDefinition>> toOperationMappingResult(OperationDefinition operation) {
        return Collector.of(() -> new OperationMappingResult(operation), RootDefinitionMappingResult::add, (omr1, omr2) -> RootDefinitionMappingResult.combine(x$0 -> new OperationMappingResult((OperationDefinition)x$0), omr1, omr2), new Collector.Characteristics[0]);
    }

    private static class OperationMappingResult
    extends RootDefinitionMappingResult<OperationDefinition> {
        private OperationMappingResult(OperationDefinition definition) {
            super(definition);
        }

        @Override
        OperationDefinition toDefinition() {
            return OperationDefinition.newOperationDefinition().name(((OperationDefinition)this.definition).getName()).operation(((OperationDefinition)this.definition).getOperation()).variableDefinitions(((OperationDefinition)this.definition).getVariableDefinitions()).directives(((OperationDefinition)this.definition).getDirectives()).selectionSet(new SelectionSet((Collection)this.selections)).build();
        }
    }
}

