package com.atlassian.braid.transformation;

import com.atlassian.braid.FieldTransformationContext;
import com.atlassian.braid.source.TrimFieldsSelection;
import com.atlassian.braid.source.VariableNamespacingGraphQLQueryVisitor;
import graphql.language.AstTransformer;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.NodeVisitor;
import graphql.language.OperationDefinition;
import graphql.schema.DataFetchingEnvironment;

import java.util.List;

class QueryTransformationUtils {

    static FieldWithCounter cloneTrimAndAliasField(FieldTransformationContext fieldTransformationContext,
                                                   List<Integer> usedCounterIds,
                                                   DataFetchingEnvironment environment,
                                                   boolean skipTopLevelField) {
        Field field = environment.getField().deepCopy();
        String alias = field.getName() + fieldTransformationContext.getCounter().incrementAndGet();
        field = field.transform(builder ->
                builder.alias(alias)
        );
        usedCounterIds.add(fieldTransformationContext.getCounter().get());

        TrimFieldsSelection.FieldAndReferencedFragments fieldAndReferencedFragments =
                TrimFieldsSelection.trimFieldSelection(fieldTransformationContext.getSchemaSource(), environment, field, skipTopLevelField);
        return new FieldWithCounter(fieldAndReferencedFragments.field, fieldTransformationContext.getCounter().get(), fieldAndReferencedFragments.referencedFragments);
    }

    static void addFieldToQuery(FieldTransformationContext fieldTransformationContext,
                                DataFetchingEnvironment environment,
                                OperationDefinition operationDefinition,
                                FieldWithCounter field) {
        final NodeVisitor variableNamespacer =
                new VariableNamespacingGraphQLQueryVisitor(field.counter,
                        operationDefinition,
                        fieldTransformationContext.getVariables(),
                        environment,
                        fieldTransformationContext);
        field.referencedFragments.forEach(fragmentDefinition -> {
            if (fieldTransformationContext.containsFragmentDefinition(fragmentDefinition.getName())) {
                return;
            }
            AstTransformer astTransformer = new AstTransformer();
            FragmentDefinition newFragmentDefinition = (FragmentDefinition) astTransformer.transform(fragmentDefinition, variableNamespacer);
            fieldTransformationContext.addFragmentDefinition(newFragmentDefinition);
        });

        AstTransformer astTransformer = new AstTransformer();
        field.field = (Field) astTransformer.transform(field.field, variableNamespacer);
        fieldTransformationContext.addSelection(field.field);
    }
}
