/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.ArgumentValueProvider;
import com.atlassian.braid.BatchLoaderUtils;
import com.atlassian.braid.FieldKey;
import com.atlassian.braid.FieldTransformation;
import com.atlassian.braid.FieldTransformationContext;
import com.atlassian.braid.Link;
import com.atlassian.braid.LinkUtils;
import com.atlassian.braid.java.util.BraidFutures;
import com.atlassian.braid.source.RelativeGraphQLError;
import com.atlassian.braid.transformation.BatchMapping;
import com.atlassian.braid.transformation.DataFetcherUtils;
import com.atlassian.braid.transformation.FieldWithCounter;
import com.atlassian.braid.transformation.QueryTransformationUtils;
import graphql.GraphQLError;
import graphql.execution.DataFetcherResult;
import graphql.execution.MergedField;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.Field;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.Value;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.dataloader.DataLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkTransformation
implements FieldTransformation {
    private static final Logger log = LoggerFactory.getLogger(LinkTransformation.class);
    private final Link link;
    private final BatchMapping batchMapping;

    LinkTransformation(Link link, BatchMapping batchMapping) {
        this.link = Objects.requireNonNull(link);
        this.batchMapping = batchMapping;
    }

    public Link getLink() {
        return this.link;
    }

    public BatchMapping getBatchMapping() {
        return this.batchMapping;
    }

    @Override
    public CompletableFuture<List<Field>> apply(DataFetchingEnvironment environment, FieldTransformationContext context) {
        Field cloneOfCurrentField = environment.getField().deepCopy();
        List selections = cloneOfCurrentField.getSelectionSet().getSelections();
        Set<String> shortCircuitFields = LinkTransformation.selectFieldsForShortCircuit(selections, this.link);
        if (this.link.isSimpleLink()) {
            return BatchLoaderUtils.getTargetIdsFromEnvironment(this.link.getSourceInputFieldName(), environment).thenCompose(targetIds -> {
                CompletableFuture[] futureFields = (CompletableFuture[])targetIds.stream().map(targetId -> this.transformSimpleLink(targetId, context, environment, shortCircuitFields)).toArray(CompletableFuture[]::new);
                return BraidFutures.all(Collectors.toList(), futureFields);
            });
        }
        return this.transformComplexLink(context, environment, shortCircuitFields);
    }

    private CompletableFuture<Field> transformSimpleLink(Object argumentValue, FieldTransformationContext context, DataFetchingEnvironment environment, Set<String> shortCircuitFields) {
        FieldWithCounter field = QueryTransformationUtils.cloneTrimAndAliasField(context, new ArrayList<Integer>(), environment, true);
        CompletableFuture<List<LinkUtils.ResolvedArgument>> args = LinkUtils.resolveArgumentsForLink(this.link, context.getSchemaSource(), environment, ArgumentValueProvider.staticArgumentValue(argumentValue), field.counter);
        return args.thenApply(resolvedArguments -> this.createFieldForSelection(field, environment, context, shortCircuitFields, (List<LinkUtils.ResolvedArgument>)resolvedArguments));
    }

    private CompletableFuture<List<Field>> transformComplexLink(FieldTransformationContext context, DataFetchingEnvironment environment, Set<String> shortCircuitFields) {
        FieldWithCounter field = QueryTransformationUtils.cloneTrimAndAliasField(context, new ArrayList<Integer>(), environment, true);
        CompletableFuture<List<LinkUtils.ResolvedArgument>> args = LinkUtils.resolveArgumentsForLink(this.link, context.getSchemaSource(), environment, this.link.getArgumentValueProvider(), field.counter);
        return args.thenApply(resolvedArguments -> Collections.singletonList(this.createFieldForSelection(field, environment, context, shortCircuitFields, (List<LinkUtils.ResolvedArgument>)resolvedArguments)));
    }

    private Field createFieldForSelection(FieldWithCounter field, DataFetchingEnvironment environment, FieldTransformationContext context, Set<String> shortCircuitFields, List<LinkUtils.ResolvedArgument> resolvedArguments) {
        if (!LinkTransformation.areAllArgumentsValuesAllowed(resolvedArguments)) {
            context.getShortCircuitedData().put(new FieldKey(field.field.getAlias()), null);
        } else if (shortCircuitFields != null) {
            Map<String, Object> result = resolvedArguments.stream().filter(arg -> shortCircuitFields.contains(arg.getLinkArgument().getTargetFieldMatchingArgument())).collect(Collectors.toMap(arg -> arg.getLinkArgument().getTargetFieldMatchingArgument(), LinkUtils.ResolvedArgument::getValue));
            context.getShortCircuitedData().put(new FieldKey(field.field.getAlias()), result);
        } else {
            OperationDefinition operationDefinition = environment.getOperationDefinition();
            this.createQueryField(context, field, resolvedArguments);
            QueryTransformationUtils.addFieldToQuery(context, environment, operationDefinition, field);
        }
        return field.field;
    }

    private void createQueryField(FieldTransformationContext fieldTransformationContext, FieldWithCounter field, List<LinkUtils.ResolvedArgument> resolvedArguments) {
        if (this.link.getCustomTransformation() != null) {
            this.link.getCustomTransformation().createQuery(field.field, null);
            return;
        }
        field.field = field.field.transform(builder -> builder.name(this.link.getTopLevelQueryField()));
        ArrayList<Argument> fieldArguments = new ArrayList<Argument>(resolvedArguments.size());
        for (LinkUtils.ResolvedArgument resolvedArgument : resolvedArguments) {
            fieldTransformationContext.addVariableDefinition(resolvedArgument.getVariableDefinition());
            fieldArguments.add(resolvedArgument.getArgument());
            fieldTransformationContext.getVariables().put(resolvedArgument.getVariableDefinition().getName(), resolvedArgument.getValue());
        }
        field.field = field.field.transform(builder -> builder.arguments(fieldArguments));
    }

    private static boolean areAllArgumentsValuesAllowed(List<LinkUtils.ResolvedArgument> resolvedArguments) {
        return resolvedArguments.stream().noneMatch(arg -> arg.getValue() == null && !arg.getLinkArgument().isNullable());
    }

    private static Set<String> selectFieldsForShortCircuit(List<Selection> selections, Link link) {
        HashSet<String> selectionFields = new HashSet<String>();
        for (Selection selection : selections) {
            if (!(selection instanceof Field)) {
                return null;
            }
            String fieldName = ((Field)selection).getName();
            if (!link.isFieldMatchingArgument(fieldName)) {
                return null;
            }
            selectionFields.add(fieldName);
        }
        return selectionFields;
    }

    @Override
    public DataFetcherResult<Object> unapply(DataFetchingEnvironment environment, DataFetcherResult<Object> dataFetcherResult) {
        if (this.link.getCustomTransformation() != null) {
            return this.link.getCustomTransformation().unapplyForResult(environment.getField(), dataFetcherResult);
        }
        return dataFetcherResult;
    }

    public CompletionStage<List<DataFetcherResult<Object>>> batchQueries(List<DataFetchingEnvironment> environments, FieldTransformationContext fieldTransformationContext) {
        DataFetchingEnvironment env = environments.get(0);
        String dataLoaderKey = DataFetcherUtils.getDataLoaderKey("Query", this.batchMapping.batchField);
        OperationDefinition queryOp = fieldTransformationContext.getOperation();
        DataFetchingEnvironment batchEnv = this.getDataFetchingEnvironment(queryOp, fieldTransformationContext, env);
        DataLoader batchDataLoader = env.getDataLoader(dataLoaderKey);
        CompletionStage results = batchDataLoader.load((Object)batchEnv).thenApply(listResult -> {
            List dataList = (List)listResult.getData();
            List errors = listResult.getErrors();
            if (dataList == null) {
                return environments.stream().map(environment -> DataFetcherResult.newResult().data(null).errors(LinkTransformation.processRelativeGraphQLError(errors, environment)).localContext(listResult.getLocalContext()).build()).collect(Collectors.toList());
            }
            return dataList.stream().map(data -> DataFetcherResult.newResult().data(data).errors(errors).localContext(listResult.getLocalContext()).build()).collect(Collectors.toList());
        });
        batchDataLoader.dispatch();
        return results;
    }

    private DataFetchingEnvironment getDataFetchingEnvironment(OperationDefinition queryOp, FieldTransformationContext fieldTransformationContext, DataFetchingEnvironment env) {
        ArrayList<Argument> batchArgs = new ArrayList<Argument>();
        ArrayValue batchArgValue = ArrayValue.newArrayValue().values(queryOp.getSelectionSet().getSelections().stream().filter(selection -> selection instanceof Field).map(selection -> (Field)selection).map(field -> field.getArguments().stream().map(argument -> new ObjectField(argument.getName(), argument.getValue())).collect(Collectors.toList())).map(ObjectValue::new).collect(Collectors.toList())).build();
        batchArgs.add(Argument.newArgument().name(this.batchMapping.batchArgName).value((Value)batchArgValue).build());
        Field batchField = env.getField().transform(builder -> builder.name(this.batchMapping.batchField).arguments(batchArgs));
        List argsList = queryOp.getSelectionSet().getSelections().stream().filter(selection -> selection instanceof Field).map(selection -> (Field)selection).map(field -> field.getArguments().stream().collect(Collectors.toMap(Argument::getName, Argument::getValue))).collect(Collectors.toList());
        HashMap arguments = new HashMap();
        arguments.put(this.batchMapping.batchArgName, argsList);
        return DataFetchingEnvironmentImpl.newDataFetchingEnvironment((DataFetchingEnvironment)env).variables(fieldTransformationContext.getVariables()).operationDefinition(queryOp).fieldDefinition(env.getFieldDefinition()).mergedField(MergedField.newMergedField().addField(batchField).build()).arguments(arguments).build();
    }

    private static List<GraphQLError> processRelativeGraphQLError(List<GraphQLError> errors, DataFetchingEnvironment environment) {
        return errors.stream().map(error -> error instanceof RelativeGraphQLError ? ((RelativeGraphQLError)error).updateBasePath(environment.getExecutionStepInfo().getPath()) : error).collect(Collectors.toList());
    }
}

