/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.switching;

import com.atlassian.braid.BatchLoaderEnvironment;
import com.atlassian.braid.Extension;
import com.atlassian.braid.FieldTransformation;
import com.atlassian.braid.Link;
import com.atlassian.braid.SchemaNamespace;
import com.atlassian.braid.SchemaSource;
import com.atlassian.braid.java.util.CompletableListCollector;
import com.atlassian.braid.source.AbstractSchemaSource;
import com.atlassian.braid.source.SchemaLoader;
import com.atlassian.braid.source.SchemaUtils;
import com.atlassian.braid.switching.NamespaceSelector;
import graphql.execution.DataFetcherResult;
import graphql.schema.DataFetchingEnvironment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.dataloader.BatchLoader;

public class SwitchingSchemaSource
extends AbstractSchemaSource {
    private Map<String, SchemaSource> delegates;
    private NamespaceSelector selector;

    SwitchingSchemaSource(SchemaNamespace namespace, SchemaLoader schemaLoader, List<SchemaSource> delegates, NamespaceSelector selector, List<Link> links, List<Extension> extensions, String ... topLevelFields) {
        super(namespace, SchemaUtils.loadPublicSchema(schemaLoader, links, topLevelFields), schemaLoader.load(), links, extensions);
        this.delegates = delegates.stream().collect(Collectors.toMap(schemaSource -> schemaSource.getNamespace().getValue(), schemaSource -> schemaSource));
        this.selector = selector;
    }

    @Override
    public BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> newBatchLoader(SchemaSource schemaSource, FieldTransformation fieldTransformation, BatchLoaderEnvironment batchLoaderEnvironment) {
        return keys -> {
            Map<String, List<DataFetchingEnvironment>> keysByNamespace = keys.stream().collect(Collectors.groupingBy(env -> this.selector.select((DataFetchingEnvironment)env)));
            return (CompletionStage)keysByNamespace.entrySet().stream().map(entry -> {
                String namespace = (String)entry.getKey();
                List keysForNamespace = (List)entry.getValue();
                SchemaSource delegate = this.delegates.get(namespace);
                BatchLoader<DataFetchingEnvironment, DataFetcherResult<Object>> batchLoader = delegate.newBatchLoader(delegate, fieldTransformation, batchLoaderEnvironment);
                CompletionStage resultsForNamespace = batchLoader.load(keysForNamespace);
                return resultsForNamespace.thenApply(results -> {
                    HashMap resultsMap = new HashMap();
                    IntStream.range(0, results.size()).forEach(i -> resultsMap.put((DataFetchingEnvironment)keysForNamespace.get(i), (DataFetcherResult)results.get(i)));
                    return resultsMap;
                });
            }).collect(new CompletableListCollector(keys));
        };
    }
}

