/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.FieldKey;
import com.atlassian.braid.source.QueryExecutorSchemaSource;
import graphql.language.Definition;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.VariableDefinition;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class FieldTransformationContext {
    private final Map<String, Object> variables;
    private final Map<DataFetchingEnvironment, List<FieldKey>> clonedFields;
    private final AtomicInteger counter;
    private final Map<FieldKey, Object> shortCircuitedData;
    private final QueryExecutorSchemaSource schemaSource;
    private final String operationName;
    private final OperationDefinition.Operation operationType;
    private final List<Selection<?>> selections;
    private final List<VariableDefinition> variableDefinitions;
    private final List<FragmentDefinition> fragmentDefinitions;
    private final Set<String> existingVariableDefinitionNames;
    private final Set<String> existingFragmentDefinitionNames;
    private final List<Field> missingFields = new ArrayList<Field>();

    public FieldTransformationContext(QueryExecutorSchemaSource schemaSource, String operationName, OperationDefinition.Operation operationType) {
        this.schemaSource = schemaSource;
        this.operationName = operationName;
        this.operationType = operationType;
        this.selections = new ArrayList();
        this.variableDefinitions = new ArrayList<VariableDefinition>();
        this.fragmentDefinitions = new ArrayList<FragmentDefinition>();
        Object document = null;
        this.variables = new HashMap<String, Object>();
        this.clonedFields = new HashMap<DataFetchingEnvironment, List<FieldKey>>();
        this.existingVariableDefinitionNames = new HashSet<String>();
        this.existingFragmentDefinitionNames = new HashSet<String>();
        this.counter = new AtomicInteger(99);
        this.shortCircuitedData = new HashMap<FieldKey, Object>();
    }

    public void addSelection(Selection<?> selection) {
        this.selections.add(selection);
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public OperationDefinition getOperation() {
        return OperationDefinition.newOperationDefinition().name(this.operationName).operation(this.operationType).selectionSet(SelectionSet.newSelectionSet().selections(this.selections).build()).variableDefinitions(this.variableDefinitions).build();
    }

    public Document getDocument() {
        Document.Builder documentBuilder = Document.newDocument();
        documentBuilder.definition((Definition)this.getOperation());
        for (FragmentDefinition fragmentDefinition : this.fragmentDefinitions) {
            documentBuilder.definition((Definition)fragmentDefinition);
        }
        return documentBuilder.build();
    }

    public void addVariableDefinition(VariableDefinition variableDefinition) {
        if (!this.existingVariableDefinitionNames.contains(variableDefinition.getName())) {
            this.variableDefinitions.add(variableDefinition);
            this.existingVariableDefinitionNames.add(variableDefinition.getName());
        }
    }

    public void addFragmentDefinition(FragmentDefinition definition) {
        if (!this.existingFragmentDefinitionNames.contains(definition.getName())) {
            this.fragmentDefinitions.add(definition);
            this.existingFragmentDefinitionNames.add(definition.getName());
        }
    }

    public Map<DataFetchingEnvironment, List<FieldKey>> getClonedFields() {
        return this.clonedFields;
    }

    public AtomicInteger getCounter() {
        return this.counter;
    }

    public QueryExecutorSchemaSource getSchemaSource() {
        return this.schemaSource;
    }

    public List<Field> getMissingFields() {
        return this.missingFields;
    }

    public Map<FieldKey, Object> getShortCircuitedData() {
        return this.shortCircuitedData;
    }

    public void addMissingFields(List<Field> missingFields) {
        this.missingFields.clear();
        this.missingFields.addAll(missingFields);
    }
}

