/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.FieldTransformationContext;
import com.atlassian.braid.source.TrimFieldsSelection;
import com.atlassian.braid.source.VariableNamespacingGraphQLQueryVisitor;
import com.atlassian.braid.transformation.FieldWithCounter;
import graphql.language.AstTransformer;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.Node;
import graphql.language.NodeVisitor;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;

class QueryTransformationUtils {
    QueryTransformationUtils() {
    }

    static FieldWithCounter cloneTrimAndAliasField(FieldTransformationContext fieldTransformationContext, List<Integer> usedCounterIds, DataFetchingEnvironment environment, boolean skipTopLevelField) {
        Field field = environment.getField().deepCopy();
        String alias = field.getName() + fieldTransformationContext.getCounter().incrementAndGet();
        field = field.transform(builder -> builder.alias(alias));
        usedCounterIds.add(fieldTransformationContext.getCounter().get());
        TrimFieldsSelection.FieldAndReferencedFragments fieldAndReferencedFragments = TrimFieldsSelection.trimFieldSelection(fieldTransformationContext.getSchemaSource(), environment, field, skipTopLevelField);
        return new FieldWithCounter(fieldAndReferencedFragments.field, fieldTransformationContext.getCounter().get(), fieldAndReferencedFragments.referencedFragments);
    }

    static void addFieldToQuery(FieldTransformationContext fieldTransformationContext, DataFetchingEnvironment environment, OperationDefinition operationDefinition, FieldWithCounter field) {
        VariableNamespacingGraphQLQueryVisitor variableNamespacer = new VariableNamespacingGraphQLQueryVisitor(field.counter, operationDefinition, fieldTransformationContext.getVariables(), environment, fieldTransformationContext);
        field.referencedFragments.forEach(arg_0 -> QueryTransformationUtils.lambda$addFieldToQuery$1((NodeVisitor)variableNamespacer, fieldTransformationContext, arg_0));
        AstTransformer astTransformer = new AstTransformer();
        field.field = (Field)astTransformer.transform((Node)field.field, (NodeVisitor)variableNamespacer);
        fieldTransformationContext.addSelection((Selection<?>)field.field);
    }

    private static /* synthetic */ void lambda$addFieldToQuery$1(NodeVisitor variableNamespacer, FieldTransformationContext fieldTransformationContext, FragmentDefinition fragmentDefinition) {
        AstTransformer astTransformer = new AstTransformer();
        FragmentDefinition newFragmentDefinition = (FragmentDefinition)astTransformer.transform((Node)fragmentDefinition, variableNamespacer);
        fieldTransformationContext.addFragmentDefinition(newFragmentDefinition);
    }
}

