/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.source;

import com.atlassian.braid.graphql.language.GraphQLNodes;
import graphql.ExecutionInput;
import graphql.language.Document;
import graphql.language.Node;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;

public class Query {
    private final Document query;
    private final String operationName;
    private final Object context;
    private final Object root;
    private final Map<String, Object> variables;

    private Query(Document query, String operationName, Object context, Object root, Map<String, Object> variables) {
        this.query = query;
        this.operationName = operationName;
        this.context = context;
        this.root = root;
        this.variables = variables;
    }

    public ExecutionInput asExecutionInput() {
        return ExecutionInput.newExecutionInput().query(GraphQLNodes.printNode((Node)this.query)).operationName(this.operationName).context(this.context).root(this.root).variables(this.variables).build();
    }

    public Document getQuery() {
        return this.query;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public Object getContext() {
        return this.context;
    }

    public Object getRoot() {
        return this.root;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Query transform(Consumer<Builder> builderConsumer) {
        Builder builder = new Builder().query(this.query).operationName(this.operationName).context(this.context).root(this.root).variables(this.variables);
        builderConsumer.accept(builder);
        return builder.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query1 = (Query)o;
        return Objects.equals(this.getQuery(), query1.getQuery()) && Objects.equals(this.getOperationName(), query1.getOperationName()) && Objects.equals(this.getContext(), query1.getContext()) && Objects.equals(this.getRoot(), query1.getRoot()) && Objects.equals(this.getVariables(), query1.getVariables());
    }

    public int hashCode() {
        return Objects.hash(this.getQuery(), this.getOperationName(), this.getContext(), this.getRoot(), this.getVariables());
    }

    public String toString() {
        return "Query{query=" + this.query + ", operationName='" + this.operationName + '\'' + ", context=" + this.context + ", root=" + this.root + ", variables=" + this.variables + '}';
    }

    public static Builder newQuery() {
        return new Builder();
    }

    public static class Builder {
        private Document query;
        private String operationName;
        private Object context;
        private Object root;
        private Map<String, Object> variables = Collections.emptyMap();

        public Builder query(Document query) {
            this.query = query;
            return this;
        }

        public Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public Builder context(Object context) {
            this.context = context;
            return this;
        }

        public Builder root(Object root) {
            this.root = root;
            return this;
        }

        public Builder variables(Map<String, Object> variables) {
            this.variables = variables;
            return this;
        }

        public Query build() {
            return new Query(this.query, this.operationName, this.context, this.root, this.variables);
        }
    }
}

