/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid.transformation;

import com.atlassian.braid.Extension;
import com.atlassian.braid.FieldRename;
import com.atlassian.braid.FieldTransformation;
import com.atlassian.braid.FieldTransformationContext;
import com.atlassian.braid.transformation.FieldWithCounter;
import com.atlassian.braid.transformation.QueryTransformationUtils;
import graphql.execution.DataFetcherResult;
import graphql.language.Field;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class TopLevelFieldTransformation
implements FieldTransformation {
    private final FieldRename fieldRename;
    private final List<Extension> extensions;

    public TopLevelFieldTransformation(FieldRename fieldRename, List<Extension> extensions) {
        this.fieldRename = fieldRename;
        this.extensions = extensions;
    }

    @Override
    public CompletableFuture<List<Field>> apply(DataFetchingEnvironment environment, FieldTransformationContext context) {
        FieldWithCounter field = QueryTransformationUtils.cloneTrimAndAliasField(context, new ArrayList<Integer>(), environment, false);
        if (this.fieldRename.getBraidName().equals(field.field.getName()) && !this.fieldRename.getSourceName().equals(field.field.getName())) {
            field.field = field.field.transform(builder -> builder.name(this.fieldRename.getSourceName()));
        }
        this.fieldRename.applyForQuery(environment, field.field);
        this.addExtensionOnFields(field);
        QueryTransformationUtils.addFieldToQuery(context, environment, environment.getOperationDefinition(), field);
        return CompletableFuture.completedFuture(Collections.singletonList(field.field));
    }

    private void addExtensionOnFields(FieldWithCounter field) {
        this.extensions.forEach(ext -> {
            if (!TopLevelFieldTransformation.selectionSetContainsField(field.field.getSelectionSet(), ext.getOn())) {
                field.field = field.field.transform(builder -> builder.selectionSet(field.field.getSelectionSet().transform(selectionSetBuilder -> selectionSetBuilder.selection((Selection)new Field(ext.getOn())))));
            }
        });
    }

    @Override
    public DataFetcherResult<Object> unapply(DataFetchingEnvironment environment, DataFetcherResult<Object> dataFetcherResult) {
        return this.fieldRename.unapplyForResult(environment.getField(), dataFetcherResult);
    }

    private static boolean selectionSetContainsField(SelectionSet selectionSet, String name) {
        return selectionSet.getSelections().stream().filter(selection -> selection instanceof Field).map(field -> (Field)field).anyMatch(field -> field.getName().equals(name));
    }
}

