/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.braid;

import com.atlassian.braid.Link;
import com.atlassian.braid.LinkArgument;
import com.atlassian.braid.java.util.BraidOptionals;
import graphql.language.FieldDefinition;
import graphql.language.ListType;
import graphql.language.Node;
import graphql.language.NonNullType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.OperationTypeDefinition;
import graphql.language.SDLDefinition;
import graphql.language.SchemaDefinition;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.idl.TypeDefinitionRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class TypeUtils {
    public static final String QUERY_FIELD_NAME = "query";
    public static final String MUTATION_FIELD_NAME = "mutation";
    public static final String DEFAULT_QUERY_TYPE_NAME = "Query";
    public static final String DEFAULT_MUTATION_TYPE_NAME = "Mutation";

    private TypeUtils() {
    }

    static ObjectTypeDefinition createDefaultQueryTypeDefinition() {
        return new ObjectTypeDefinition(DEFAULT_QUERY_TYPE_NAME);
    }

    static ObjectTypeDefinition createDefaultMutationTypeDefinition() {
        return new ObjectTypeDefinition(DEFAULT_MUTATION_TYPE_NAME);
    }

    public static ObjectTypeDefinition addQueryTypeToSchema(TypeDefinitionRegistry typeDefinitionRegistry, ObjectTypeDefinition objectTypeDefinition) {
        TypeUtils.addObjectTypeToSchemaDefinition(typeDefinitionRegistry, QUERY_FIELD_NAME, DEFAULT_QUERY_TYPE_NAME);
        typeDefinitionRegistry.add((SDLDefinition)objectTypeDefinition);
        return objectTypeDefinition;
    }

    public static void addMutationTypeToSchema(TypeDefinitionRegistry typeDefinitionRegistry, ObjectTypeDefinition objectTypeDefinition) {
        TypeUtils.addObjectTypeToSchemaDefinition(typeDefinitionRegistry, MUTATION_FIELD_NAME, DEFAULT_MUTATION_TYPE_NAME);
        typeDefinitionRegistry.add((SDLDefinition)objectTypeDefinition);
    }

    private static void addObjectTypeToSchemaDefinition(TypeDefinitionRegistry registry, String operationFieldName, String operationTypeName) {
        SchemaDefinition originalSchemaDef = (SchemaDefinition)registry.schemaDefinition().orElseThrow(IllegalStateException::new);
        SchemaDefinition modifiedSchemaDef = originalSchemaDef.transform(builder -> builder.operationTypeDefinition(new OperationTypeDefinition(operationFieldName, new TypeName(operationTypeName))));
        registry.remove((SDLDefinition)originalSchemaDef);
        registry.add((SDLDefinition)modifiedSchemaDef);
    }

    public static Optional<List<FieldDefinition>> findQueryFieldDefinitions(TypeDefinitionRegistry registry) {
        return TypeUtils.findQueryType(registry).map(ObjectTypeDefinition::getFieldDefinitions);
    }

    public static Optional<ObjectTypeDefinition> findQueryType(TypeDefinitionRegistry registry) throws IllegalArgumentException {
        return BraidOptionals.firstNonEmpty(() -> TypeUtils.findOperationType(registry, TypeUtils::isQueryOperation), () -> TypeUtils.getObjectTypeDefinitionByName(registry, DEFAULT_QUERY_TYPE_NAME));
    }

    public static Optional<ObjectTypeDefinition> findMutationType(TypeDefinitionRegistry registry) throws IllegalArgumentException {
        return BraidOptionals.firstNonEmpty(() -> TypeUtils.findOperationType(registry, TypeUtils::isMutationOperation), () -> TypeUtils.getObjectTypeDefinitionByName(registry, DEFAULT_MUTATION_TYPE_NAME));
    }

    private static Optional<ObjectTypeDefinition> findOperationType(TypeDefinitionRegistry registry, Predicate<OperationTypeDefinition> isQueryOperation) {
        return TypeUtils.findOperationDefinitions(registry).flatMap(definitions -> TypeUtils.findOperationDefinition(definitions, isQueryOperation)).flatMap(TypeUtils.getObjectTypeDefinition(registry));
    }

    static List<ObjectTypeDefinition> findOperationTypes(TypeDefinitionRegistry registry) {
        return TypeUtils.findOperationDefinitions(registry).map(TypeUtils.toObjectTypeDefinition(registry)).orElse(Collections.emptyList());
    }

    public static Optional<List<OperationTypeDefinition>> findOperationDefinitions(TypeDefinitionRegistry registry) {
        return registry.schemaDefinition().map(SchemaDefinition::getOperationTypeDefinitions);
    }

    public static String unwrap(Type wrappedOriginal) {
        Type current = wrappedOriginal;
        while (true) {
            if (current instanceof NonNullType) {
                current = ((NonNullType)current).getType();
                continue;
            }
            if (!(current instanceof ListType)) break;
            current = ((ListType)current).getType();
        }
        if (current instanceof TypeName) {
            return ((TypeName)current).getName();
        }
        throw new IllegalArgumentException("Unexpected type wrapper: " + current);
    }

    private static Optional<OperationTypeDefinition> findOperationDefinition(List<OperationTypeDefinition> definitions, Predicate<OperationTypeDefinition> isOperation) {
        return definitions.stream().filter(isOperation).findFirst();
    }

    private static boolean isQueryOperation(OperationTypeDefinition operationTypeDefinition) {
        return Objects.equals(operationTypeDefinition.getName(), QUERY_FIELD_NAME);
    }

    private static boolean isMutationOperation(OperationTypeDefinition operationTypeDefinition) {
        return Objects.equals(operationTypeDefinition.getName(), MUTATION_FIELD_NAME);
    }

    public static TypeDefinitionRegistry filterQueryType(TypeDefinitionRegistry registry, List<Link> links, String ... topLevelFields) {
        Optional<ObjectTypeDefinition> queryDefOptional;
        List<String> topFields = Arrays.asList(topLevelFields);
        if (!topFields.isEmpty() && (queryDefOptional = TypeUtils.findQueryType(registry)).isPresent()) {
            ObjectTypeDefinition queryDef = queryDefOptional.get();
            List linkReplacedSourceFromFields = links.stream().filter(link -> link.getSourceType().equals(queryDef.getName()) && topFields.contains(link.getNewFieldName())).flatMap(link -> link.getLinkArguments().stream()).filter(linkArgument -> linkArgument.getArgumentSource() == LinkArgument.ArgumentSource.OBJECT_FIELD && linkArgument.isRemoveInputField()).map(LinkArgument::getSourceName).collect(Collectors.toList());
            ArrayList<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>(queryDef.getFieldDefinitions());
            fieldDefinitions.removeIf(field -> !linkReplacedSourceFromFields.contains(field.getName()) && !topFields.contains(field.getName()));
            ObjectTypeDefinition newQueryDef = queryDef.transform(builder -> builder.fieldDefinitions(fieldDefinitions));
            registry.remove((SDLDefinition)queryDef);
            registry.add((SDLDefinition)newQueryDef);
        }
        return registry;
    }

    private static Function<List<OperationTypeDefinition>, List<ObjectTypeDefinition>> toObjectTypeDefinition(TypeDefinitionRegistry registry) {
        return ods -> ods.stream().map(TypeUtils.getObjectTypeDefinition(registry)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static Function<OperationTypeDefinition, Optional<ObjectTypeDefinition>> getObjectTypeDefinition(TypeDefinitionRegistry registry) {
        return otd -> registry.getType((Type)otd.getTypeName()).map(ObjectTypeDefinition.class::cast);
    }

    private static Optional<ObjectTypeDefinition> getObjectTypeDefinitionByName(TypeDefinitionRegistry registry, String typeName) {
        return registry.getType(typeName).map(ObjectTypeDefinition.class::cast);
    }

    static boolean isEqual(Node node1, Node node2) {
        if (null == node1) {
            return null == node2;
        }
        if (!node1.isEqualTo(node2)) {
            return false;
        }
        List children1 = node1.getChildren();
        List children2 = node2.getChildren();
        if (children1.size() != children2.size()) {
            return false;
        }
        for (int i = 0; i < children1.size(); ++i) {
            if (TypeUtils.isEqual((Node)children1.get(i), (Node)children2.get(i))) continue;
            return false;
        }
        return true;
    }
}

